% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPhylo.R
\name{addPhylo}
\alias{addPhylo}
\title{addPhylo}
\usage{
addPhylo(x, tree, replace = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{tree}{a phylogeny of class \code{phylo}, or a set of trees of class \code{multiPhylo}}

\item{replace}{boolean; if a tree is already a part of \code{x}, should it
be replaced?}

\item{verbose}{if TRUE, list out all species that are dropped/excluded,
rather than counts.}
}
\value{
object of class \code{epmGrid}, with a \code{phylo} object as the
  list element named \code{phylo}.
}
\description{
Add a phylogeny to epmGrid object.
}
\details{
If any species in the phylogeny are not found in the epmGrid
  geographical data, then those species will be dropped from the phylogeny,
  and a warning will be issued.

	 If providing a set of trees as a multiPhylo object, it is expected that all
	  trees have the same tips.
}
\examples{
tamiasEPM
tamiasTree

addPhylo(tamiasEPM, tamiasTree)

}
\author{
Pascal Title
}
