% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.bias.R
\name{boot.bias}
\alias{boot.bias}
\title{Bootstrap resampling for selection and misclassification bias models.}
\usage{
boot.bias(bias_model, R = 1000, conf = 0.95, ci_type = c("norm", "perc"))
}
\arguments{
\item{bias_model}{An object of class "episensr.boot", i.e. either selection bias function or misclassification bias function.}

\item{R}{The number of bootstrap replicates.}

\item{conf}{Confidence level.}

\item{ci_type}{A character string giving the type of interval required. Values can be either "norm" or "perc", default to "norm".}
}
\value{
A list with elements:
\item{model}{Model ran.}
\item{boot_mod}{Bootstrap resampled object, of class \code{boot}.}
\item{nrep}{Number of replicates used.}
\item{bias_ciRR}{Bootstrap confidence interval object for relative risk.}
\item{bias_ciOR}{Bootstrap confidence interval object for odds ratio.}
\item{ci}{Confidence intervals for the bias adjusted association measures.}
\item{conf}{Confidence interval.}
}
\description{
Generate \code{R} bootstrap replicates of either selection or misclassification bias functions.
It then generates a confidence interval of the parameter, by first order normal approximation or the bootstrap percentile interval.
Replicates giving negative cell(s) in the adjusted 2-by-2 table are silently ignored.
}
\examples{
misclass_eval <- misclassification(matrix(c(215, 1449, 668, 4296),
dimnames = list(c("Breast cancer+", "Breast cancer-"),
c("Smoker+", "Smoker-")),
nrow = 2, byrow = TRUE),
type = "exposure",
bias_parms = c(.78, .78, .99, .99))

set.seed(123)
boot.bias(misclass_eval)
}
\seealso{
\code{\link{boot}, \link{selection}, \link{misclassification}}
}
