% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobian.R
\name{jacobian}
\alias{jacobian}
\title{A Jacobian matrix calculator}
\usage{
jacobian(states, elist, parameters, pts)
}
\arguments{
\item{states}{a vector naming all state variables}

\item{elist}{a list that contains equations (as quotes) for all state variables}

\item{parameters}{a labeled vector of parameters}

\item{pts}{a labeled vector of the point in the phase plane in which to evaluate the Jacobian 
(often the endemic or disease-free equilibrium if working in mathematical epidemiology)}
}
\value{
The Jacobian matrix
}
\description{
A general-purpose function to construct and evaluate Jacobian matrices
}
\examples{
#The SEIR model
states=c("S", "E", "I", "R")
elist=c(dS = quote(mu * (N  - S)  - beta * S * I / N),
 dE = quote(beta * S * I / N - (mu + sigma) * E),
dI = quote(sigma * E - (mu + gamma+alpha) * I),
dR = quote(gamma * I - mu * R))
paras  = c(mu = 1/50, N = 1, beta =  1000, 
sigma = 365/8, gamma = 365/5, alpha=0)
deq=list(S = 1, E = 0, I = 0, R = 0)
jacobian(states=states, elist=elist, parameters=paras, pts=deq)
}
