% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listNumericIncompatibility.R
\name{listNumericIncompatibility}
\alias{listNumericIncompatibility}
\title{List incompatible values when converted into numeric values.}
\usage{
listNumericIncompatibility(data = NULL)
}
\arguments{
\item{data}{a data.frame to search for incomatible values when converted into numeric values}
}
\value{
a list which contains incompatible values for each variable in data.frame when converted into numeric variable.
}
\description{
List incompatible values when converted into numeric values.
}
\details{
List incompatible values when converted into numeric values. Character or factor variables in data.frame are scanned to check whether the values in it is compatible, and incompatible values are returned as list. This function is intended for check before use of \code{convertFromFactor}.
}
\examples{
a <- factor(rnorm(5))
b <- c("a", "b", "c", "d", "e")
c <- c("1", "2", "3", "4", NA)
d <- c("1", "2", "3", "4", ".")
dat <- data.frame(a,b,c,d)
listNumericIncompatibility(dat)
}
\seealso{
\code{\link{convertFromFactor}}, \code{\link{showContents}}.
}

