% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pytable.R
\name{pytable}
\alias{pytable}
\title{Make person-year table from individual data}
\usage{
pytable(event, time, cov, scale = 1)
}
\arguments{
\item{event}{a vector specifying number of event}

\item{time}{a vector specifying time variable}

\item{cov}{vector or matrix or data.frame of covariates}

\item{scale}{a scaling for person-year. The value of 365.25 will make person-year table from time variable recoded as days.}
}
\value{
a person-year data.frame
}
\description{
Make person-year table from individual data
}
\details{
This function creates the person-years table from event, time and covariate data. The number of event and time of some observations with the same covariate data are summed up, and made into one observation.
}
\examples{
event <- c(1,0,2,1,1,0,1,1)
time <- c(3,5,12,4,6,2,5,2)
cov1 <- c(3,2,4,2,3,2,1,1)
cov2 <- c(0,0,0,0,1,1,1,1)
pytable(event, time, cbind(cov1,cov2))
}

