\name{epi.epidural}

\docType{data}

\alias{epi.epidural}

\title{Rates of use of epidural anaesthesia in trials of caregiver support}

\description{
This data set provides results of six trials investigating rates of use of epidural anaesthesia during childbirth. Each trial is made up of a group where a caregiver (midwife, nurse) provided support intervention and a group where standard care was provided. The objective was to determine if there were higher rates of epidural use when a caregiver was present at birth. 
}

\usage{data(epi.epidural)}

\format{
  A data frame with 6 observations on the following 5 variables.
  \describe{
    \item{trial}{the name and year of the trial.}
    \item{ev.trt}{number of births in the caregiver group where an epidural was used.}
    \item{n.trt}{number of births in the caregiver group.}
    \item{ev.ctrl}{number of births in the standard care group where an epidural was used.}
    \item{n.ctrl}{number of births in the standard care group.}
  }
}

\references{
Deeks JJ, Altman DG, Bradburn MJ (2001). Statistical methods for examining heterogeneity and combining results from several studies in meta-analysis. In: Egger M, Davey Smith G, Altman D (eds). Systematic Review in Health Care Meta-Analysis in Context. British Medical Journal, London, pp. 291 - 299. 
}

\keyword{datasets}
