% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveLinkDefinition}
\alias{AddListRemoveLinkDefinition}
\alias{add_linkDefinition}
\alias{list_linkDefinitions}
\alias{remove_linkDefinition}
\title{Add / List / Remove linkDefinition to / of / from emuDB}
\usage{
add_linkDefinition(emuDBhandle, type, superlevelName, sublevelName)

list_linkDefinitions(emuDBhandle)

remove_linkDefinition(
  emuDBhandle,
  superlevelName,
  sublevelName,
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{type}{type of linkDefinition (either \code{"ONE_TO_MANY"}, \code{"MANY_TO_MANY"} or \code{"ONE_TO_ONE"})}

\item{superlevelName}{name of super-level of linkDefinition}

\item{sublevelName}{name of sub-level of linkDefinition}

\item{force}{delete all links belonging to the linkDefinition (\strong{USE WITH CAUTION! VERY INVASIVE AKTION!})}

\item{verbose}{be verbose. Ask to delete links if \code{force} is \code{TRUE}.}
}
\description{
Add / List / Remove new link definition to / of / from emuDB. A link definition
specifies the relationship between two levels, the
super-level and the sub-level. The entirety of all link 
definitions of a emuDB specifies the 
hierarchical structure of the database. For more information
on the structural elements of an emuDB see \code{vignette(emuDB)}.
}
\details{
Link type descriptions:
\itemize{
\item{\code{"ONE_TO_MANY"}}{A single ITEM of the super-level can be linked to multiple ITEMs of the sub-level}
\item{\code{"MANY_TO_MANY"}}{Multiple ITEMs of the super-level can be linked to multiple ITEMs of the sub-level}
\item{\code{"ONE_TO_ONE"}}{A single ITEM of the super-level can be linked to a single ITEM of the sub-level}
}

For all link types the rule applies that no links are allowed to cross any other links.
Further, a linkDefinition can not be removed, if there are links present in the emuDB.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded emuDB that was converted
# using the convert_TextGridCollection function called myTGcolDB
# (see ?load_emuDB and ?convert_TextGridCollection for more information)

# add link definition from super-level "Phoneme"
# to sub-level "Phonetic" of type "ONE_TO_MANY"
# for myTGcolDB emuDB
add_linkDefinition(emuDBhandle = myTGcolDB,
                   type = "ONE_TO_MANY",
                   superlevelName = "Phoneme",
                   sublevelName = "Phonetic")

# list link definitions for myTGcolDB emuDB
list_linkDefinitions(emuDBhandle = myTGcolDB)

# remove newly added link definition
remove_linkDefinition(emuDBhandle = myTGcolDB,
                      superlevelName = "Phoneme",
                      sublevelName = "Phonetic")


}
}
