% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.R
\name{rename_bundles}
\alias{rename_bundles}
\title{Rename bundles in emuDB}
\usage{
rename_bundles(emuDBhandle, bundles)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{bundles}{data.frame like object with the columns
\itemize{
\item \code{session}: name of sessions containing bundle
\item \code{name}: name of bundle
\item \code{name_new}: new name given to bundle
}
It is worth noting that \code{session} and \code{name} are the columns returned by 
\code{\link{list_bundles}}.}
}
\description{
Rename bundles of emuDB.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB
# (see ?load_emuDB for more information)

# list bundles of session "0000" of ae emuDB
bundles = list_bundles(emuDBhandle = ae,
                       session = "0000")

# append "XXX" to bundle names and rename
bundles$name_new = paste0(bundles$name, "XXX")
rename_bundles(emuDBhandle, bundles)
}

}
