% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_maus}
\alias{runBASwebservice_maus}
\title{Runs MAUS webservice to create a phonetic segmentation}
\usage{
runBASwebservice_maus(handle, canoAttributeDefinitionName, language,
  mausAttributeDefinitionName = "MAU", chunkLevel = NULL,
  turnChunkLevelIntoItemLevel = TRUE, params = NULL,
  perspective = "default", patience = 0, resume = FALSE,
  verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{canoAttributeDefinitionName}{name of the attribute (not level!) containing the SAMPA word pronunciations.
If this attribute resides on a segment level, the segment time information is used as a presegmentation.
If it is an item level, no assumption is made about the temporal position of segments.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{mausAttributeDefinitionName}{attribute name for the MAUS segmentation}

\item{chunkLevel}{if you have a chunk segmentation level, you can provide it to improve the speed and accuracy
of MAUS. The chunk segmentation level must be a segment level, and it must link to the level of canoAttributeDefinitionName.}

\item{turnChunkLevelIntoItemLevel}{if TRUE, and if a chunk level is provided, the chunk level is converted into an ITEM level after segmentation}

\item{params}{named list of parameters to be passed on to the webservice. It is your own responsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{perspective}{the webApp perspective that the new level will be added to.
If NULL, the new level is not added to any perspectives.}

\item{patience}{If a web service call fails, it is repeated a further n times, with n being the value of patience.
Must be set to a value between 0 and 3.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the BAS webservice MAUS to generate a phonemic segmentation.
It requires a word-tokenized tier with a SAMPA pronunciation, which can be generated
by the function \link{runBASwebservice_g2pForPronunciation}.
\strong{This function requires an internet connection.}
}
\details{
All necessary level, link and attribute definitions are created in the process.
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
\concept{BAS webservice functions}
