\name{congruence}
\alias{congruence}
\title{Solves mx+by=1 for x and y}
\description{
  Solves the Diophantine equation \eqn{mx+by=1}{mx+by=1} for \eqn{x}{x}
  and \eqn{y}{y}.  The function is named for equation 57 in Hardy and Wright.
}
\usage{
congruence(a, l = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{a}{Two element vector with \code{a=c(m,n)}}
  \item{l}{Right hand side with default 1}
}
\value{

  In the usual case of \eqn{(m,n)=1}{(m,n)=1}, returns a square matrix
whose rows are \code{a} and \code{c(x,y)}.  This matrix is a unimodular
transformation that takes a pair of basic periods to another pair of
basic periods.

If \eqn{(m,n)\neq 1}{+(m,n) != 1} then more than one solution is
available (for example \code{congruence(c(4,6),2)}).  In this case, extra rows
are added and the matrix is no longer square.

}
\references{Hardy and Wright}
\author{Robin K. S. Hankin}
\note{
  This function does not generate \emph{all} unimodular matrices with a
  given first row (here, it will be assumed that the function returns a
  square matrix).

    For a start, this function only returns matrices all of whose elements
    are positive, and if \code{a} is unimodular, then after \code{diag(a)
    <- -diag(a)}, both \code{a} and \code{-a} are unimodular (so if
    \code{a} was originally generated by \code{congruence()}, neither of the
    derived matrices could be).
  
    Now if the first row is \code{c(1,23)}, for example, then the second
    row need only be of the form \code{c(n,1)} where \code{n} is any
    integer.  There are thus an infinite number of  unimodular matrices
    whose first row is \code{c(1,23)}.  While this is (somewhat)
    pathological, consider matrices with a first row of, say,
    \code{c(2,5)}.  Then the second row could be \code{c(1,3)}, or
    \code{c(3,8)} or \code{c(5,13)}.  Function \code{congruence()} will return
    only the first of these.

    To systematically generate unimodular matrices, use
    \code{unimodular()}, which uses Farey sequences.
    
  }

\seealso{\code{\link{unimodular}}}
\examples{
M <- congruence(c(4,9))
det(M)

o <- c(1,1i)
g2.fun(o) - g2.fun(o,maxiter=840)  #should be zero

}
\keyword{math}
