% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/print.effectsize_table.R
\name{plot.effectsize_table}
\alias{plot.effectsize_table}
\alias{plot.equivalence_test_effectsize}
\alias{print.effectsize_table}
\alias{format.effectsize_table}
\alias{print.effectsize_difference}
\title{Methods for \code{effectsize} tables}
\usage{
\method{plot}{effectsize_table}(x, ...)

\method{plot}{equivalence_test_effectsize}(x, ...)

\method{print}{effectsize_table}(x, digits = 2, ...)

\method{format}{effectsize_table}(x, digits = 2, ...)

\method{print}{effectsize_difference}(x, digits = 2, append_CLES = FALSE, ...)
}
\arguments{
\item{x}{Object to print.}

\item{...}{Arguments passed to or from other functions.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{append_CLES}{Should the Common Language Effect Sizes be printed as well?
Only applicable to Cohen's \emph{d}, Hedges' \emph{g} for independent samples of
equal variance (pooled sd) or for the rank-biserial correlation for
independent samples (See \code{\link[=d_to_cles]{d_to_cles()}})}
}
\description{
Printing, formatting and plotting methods for \code{effectsize} tables.
}
