% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.data}
\alias{ec.data}
\title{Data helper}
\usage{
ec.data(df, format = "dataset", header = FALSE, jitter = 0, layout = "h", ...)
}
\arguments{
\item{df}{Chart data in data.frame format, required. \cr
Except when format is 'dendrogram', then df is a list, result of \link[stats]{hclust} function.\cr}

\item{format}{A key on how to format the output list \cr \itemize{
\item 'dataset' = list to be used in \href{https://echarts.apache.org/en/option.html#dataset.source}{dataset} (default), or in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} (without header). \cr
\item 'values' = list for customized \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} \cr
\item 'names' = named lists useful for named data like \href{https://echarts.apache.org/en/option.html#series-sankey.links}{sankey links}.
\item 'dendrogram' = build series data for Hierarchical Clustering dendrogram
\item 'treePC' = build series data for sunburst,tree,treemap from parent/children data.frame
\item 'treeTK' = build series data for sunburst,tree,treemap from data.frame like Titanic. Supports column \emph{itemStyle}.
\item 'boxplot' = build dataset and source lists, see Details
}}

\item{header}{for dataset, to include the column names or not, default TRUE. Set it to FALSE for \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data}.\cr}

\item{jitter}{for boxplot, value for \link[base]{jitter} of numerical values in second column, default 0 (no scatter). Adds scatter series on top of boxplot.\cr}

\item{layout}{for boxplot, 'h' for horizontal(default) or 'v' for vertical layout\cr}

\item{...}{additional parameters for the boxplot \emph{jitter} (scatter) serie\cr
Optional parameter \emph{outliers} for boxplot, a boolean to add outlier points (default FALSE)\cr}
}
\value{
A list for \emph{dataset.source}, \emph{series.data} or other lists:\cr
For boxplot - a named list, see Details and Examples \cr
For dendrogram & treePC - a tree structure, see format in \href{https://echarts.apache.org/en/option.html#series-tree.data}{tree data}
}
\description{
Make data lists from a data.frame
}
\details{
\code{format='boxplot'} requires the first two \emph{df} columns as: \cr
\itemize{
\item column for the non-computational categorical axis\cr
\item column with (numeric) data to compute the five boxplot values\cr
}

Additional grouping is supported on a column after the second. Groups will show in the legend, if enabled.\cr
Returns a \code{list(dataset, series, xAxis, yAxis)} to set params in \link{ec.init}.\cr
Make sure there is enough data for computation, 4+ values per boxplot.
}
\examples{
library(dplyr)
ds <- iris |> relocate(Species) |>
	 ec.data(format= 'boxplot', jitter= 0.1, layout= 'v')
ec.init(
  dataset= ds$dataset, series= ds$series, xAxis= ds$xAxis, yAxis= ds$yAxis,
  legend= list(show= TRUE), tooltip= list(show= TRUE)
)

hc <- hclust(dist(USArrests), "complete")
ec.init(preset= FALSE,
        series= list(list(
          type= 'tree', orient= 'TB', roam= TRUE, initialTreeDepth= -1,
          data= ec.data(hc, format='dendrogram'),
          # layout= 'radial', symbolSize= ec.clmn(scale= 0.33),
          ## exclude added labels like 'pXX', leaving only the originals
          label= list(formatter= htmlwidgets::JS(
            "function(n) { out= /p\\\\d+/.test(n.name) ? '' : n.name; return out;}"))
        ))
)

}
\seealso{
some live \href{https://rpubs.com/echarty/data-models}{code samples}
}
