% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.ebars}
\alias{ecr.ebars}
\title{Error bars}
\usage{
ecr.ebars(wt, df = NULL, hwidth = 6, ...)
}
\arguments{
\item{wt}{A widget to add error bars to, see \link[htmlwidgets]{createWidget}}

\item{df}{NULL(default) or data.frame with four or more columns ordered exactly x,y,low,high,(category),...\cr
When NULL, data is taken from wt's dataset where order should be the same x,y,low,high,(category),...}

\item{hwidth}{Half-width of error bar in pixels, default is 6.}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-custom.type}{custom serie}}
}
\value{
A widget with error bars added if successful, otherwise the input wt
}
\description{
Custom series to display error-bars for scatter,bar or line series
}
\details{
\emph{ecr.ebars} are custom series, so \emph{ec.init(load='custom')} is required. \cr
Grouped series are supported, but \emph{df} is required with group column included. \cr
Will add a chart legend and its own tooltip if none is provided.\cr
Add a name attribute to show error bars separate in the legend. \cr
Command should be called last, after all other series.\cr
Simple non-grouped series could be displayed with formatter \emph{riErrBarSimple} instead of \emph{ecr.ebars}. See example below.
}
\examples{
if (interactive()) {
library(dplyr)
tmp <- round(rnorm(24, sin(1:24/2)*10, .5))
df <- data.frame(x = 1:24, val = tmp, 
                 lower = round(rnorm(24, tmp -10, .5)),
                 upper = round(rnorm(24, tmp + 5, .8)),
                 cat= rep(c('A','B'),24) )
                 
df |> ec.init(load='custom', tooltip= list(show=TRUE)) |> ecr.ebars()
  
#------ riErrBarSimple ------
df |> ec.init(load= 'custom',
              title= list(text= "riErrBarSimple"),
              legend= list(show=TRUE),
              xAxis= list(data= df$category)) |> ec.upd({
  series <- append(series, list(list(
    type= "custom", name= "error",
    itemStyle= list(borderWidth= 1.5, color= 'brown'),
    encode= list(x= 0, y= list(1, 2)),
    data= ec.data(df |> select(x,lower,upper)),
    renderItem= htmlwidgets::JS("riErrBarSimple") )))
})

# ----- grouped -------
df |> group_by(cat) |> 
  ec.init(load= 'custom',
          xAxis= list(type='value')) |>  # fix preset 'category'
	 ecr.ebars(df)
}
}
