% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globe.R
\name{e_globe}
\alias{e_globe}
\title{Globe}
\usage{
e_globe(e, environment = NULL, base_texture = NULL, height_texture = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{environment}{Texture of background.}

\item{base_texture}{Base texture of globe.}

\item{height_texture}{Texture of height.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add globe.
}
\examples{
\dontrun{
url <- paste0(
  "https://echarts.apache.org/examples/",
  "data-gl/asset/data/population.json"
)
data <- jsonlite::fromJSON(url)
data <- as.data.frame(data)
names(data) <- c("lon", "lat", "value")

data |>
  e_charts(lon) |>
  e_globe(
    displacementScale = 0.04
  ) |>
  e_bar_3d(lat, value, "globe") |>
  e_visual_map(show = FALSE)
}

}
\seealso{
\code{\link{e_country_names}}, \href{https://echarts.apache.org/en/option-gl.html#globe}{Additional arguments}
}
