% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_lines}
\alias{e_lines}
\alias{e_lines_}
\title{Lines}
\usage{
e_lines(
  e,
  source_lon,
  source_lat,
  target_lon,
  target_lat,
  source_name,
  target_name,
  value,
  coord_system = "geo",
  name = NULL,
  rm_x = TRUE,
  rm_y = TRUE,
  ...
)

e_lines_(
  e,
  source_lon,
  source_lat,
  target_lon,
  target_lat,
  source_name = NULL,
  target_name = NULL,
  value = NULL,
  coord_system = "geo",
  name = NULL,
  rm_x = TRUE,
  rm_y = TRUE,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{source_lon, source_lat, target_lon, target_lat}{coordinates.}

\item{source_name, target_name}{Names of source and target.}

\item{value}{Value of edges.}

\item{coord_system}{Coordinate system to use, one of \code{geo}, or \code{cartesian2d}.}

\item{name}{name of the serie.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add lines.
}
\examples{
flights <- read.csv(
  paste0(
    "https://raw.githubusercontent.com/plotly/datasets/",
    "master/2011_february_aa_flight_paths.csv"
  )
)

flights \%>\%
  e_charts() \%>\%
  e_geo() \%>\%
  e_lines(
    start_lon,
    start_lat,
    end_lon,
    end_lat,
    airport1,
    airport2,
    cnt,
    name = "flights",
    lineStyle = list(normal = list(curveness = 0.3))
  ) \%>\%
  e_tooltip(
    trigger = "item",
    formatter = htmlwidgets::JS("
      function(params){
        return(
          params.seriesName +'<br />' +
          params.data.source_name + ' -> ' +
          params.data.target_name + ':'+ params.value
        )
      }
   ")
  )

# timeline
flights$grp <- rep(LETTERS[1:2], 89)

flights \%>\%
  group_by(grp) \%>\%
  e_charts(timeline = TRUE) \%>\%
  e_geo() \%>\%
  e_lines(
    start_lon,
    start_lat,
    end_lon,
    end_lat,
    cnt,
    coord_system = "geo"
  )
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-lines}{Additional arguments}
}
