% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{e_draw_p}
\alias{e_draw_p}
\title{Draw}
\usage{
e_draw_p(proxy)
}
\arguments{
\item{proxy}{An echarts4r proxy as returned by \code{\link{echarts4rProxy}}.}
}
\description{
Draw the chart.
}
\details{
Useful if you set \code{draw} to \code{FALSE} in \code{\link{e_charts}}.
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
  echarts4rOutput("chart"),
  actionButton("draw", "draw")
)

server <- function(input, output){
  output$chart <- renderEcharts4r({
    mtcars \%>\% 
      e_charts(mpg, draw = FALSE) \%>\% 
      e_scatter(qsec) \%>\% 
      e_datazoom() 
  })
  
  observeEvent(input$draw, {
    echarts4rProxy("chart") \%>\% 
      e_draw_p()
  })
}

if(interactive())
 shinyApp(ui, server)
}

}
