% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{e_mark_point}
\alias{e_mark_point}
\alias{e_mark_line}
\alias{e_mark_area}
\title{Mark point}
\usage{
e_mark_point(e, serie = NULL, data = NULL, ...)

e_mark_line(e, serie = NULL, data = NULL, ...)

e_mark_area(e, serie = NULL, data = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Serie or vector of series to mark on, defaults to all series.}

\item{data}{Placement.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Mark points and lines.
}
\examples{
max <- list(
  name = "Max",
  type = "max"
)

min <- list(
  name = "Min",
  type = "min"
)

avg <- list(
  type = "average",
  name = "AVG"
)

mtcars \%>\% 
  e_charts(mpg) \%>\% 
  e_line(wt) \%>\% 
  e_line(drat) \%>\% 
  e_line(cyl) \%>\% 
  e_mark_point("wt", data = max) \%>\% 
  e_mark_point(c("cyl", "drat"), data = min) \%>\% 
  e_mark_line(data = avg) \%>\% # applies to all
  e_mark_area(serie = "wt", data = list(
    list(xAxis = "min", yAxis = "min"), 
    list(xAxis = "max", yAxis = "max"))
 )

}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-line.markPoint}{Additional point arguments},
\href{https://echarts.apache.org/en/option.html#series-line.markLine}{Additional line arguments}
}
