% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_step}
\alias{e_step}
\alias{e_step_}
\title{Step}
\usage{
e_step(e, serie, bind, step = c("start", "middle", "end"),
  fill = FALSE, name = NULL, legend = TRUE, y_index = 0,
  x_index = 0, ...)

e_step_(e, serie, bind = NULL, step = c("start", "middle", "end"),
  fill = FALSE, name = NULL, legend = TRUE, y_index = 0,
  x_index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Column name of serie to plot.}

\item{bind}{Binding between datasets, namely for use of \code{\link{e_brush}}.}

\item{step}{Step type, one of \code{start}, \code{middle} or \code{end}.}

\item{fill}{Set to fill as area.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{y_index}{Indexes of x and y axis.}

\item{x_index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add step serie.
}
\examples{
USArrests \%>\% 
  dplyr::mutate(State = row.names(.)) \%>\% 
  e_charts(State) \%>\%
  e_step(Murder, name = "Start", step = "start", fill = TRUE) \%>\% 
  e_step(Rape, name = "Middle", step = "middle") \%>\% 
  e_step(Assault, name = "End", step = "end") \%>\% 
  e_tooltip(trigger = "axis")

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-line}{Additional arguments}
}
