% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_pictorial}
\alias{e_pictorial}
\alias{e_pictorial_}
\title{Pictorial}
\usage{
e_pictorial(e, serie, symbol, bind, name = NULL, legend = TRUE,
  y.index = 0, x.index = 0, ...)

e_pictorial_(e, serie, symbol, bind = NULL, name = NULL,
  legend = TRUE, y.index = 0, x.index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Column name of serie to plot.}

\item{symbol}{Symbol to plot.}

\item{bind}{Binding between datasets, namely for use of \code{\link{e_brush}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{y.index}{Indexes of x and y axis.}

\item{x.index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Pictorial bar chart is a type of bar chart that custimzed glyph 
(like images, SVG PathData) can be used instead of rectangular bar.
}
\section{Symbols}{

\itemize{
  \item{Built-in}{ \code{circle}, \code{rect}, \code{roundRect}, \code{triangle}, \code{diamond}, 
  \code{pin}, \code{arrow}.}
  \item{SVG Path}
  \item{Images}{ Path to image, don't forget to precede it with \code{image://}, see examples.}
}
}

\examples{
# built-in symbols
y <- rnorm(10, 10, 2)
df <- data.frame(
  x = 1:10,
  y = y,
  z = y - rnorm(10, 5, 1)
)

df \%>\% 
  e_charts(x) \%>\% 
  e_bar(z, barWidth = 10) \%>\% 
  e_pictorial(y, symbol = "rect", symbolRepeat = TRUE, z = -1,
    symbolSize = c(10, 4)) \%>\% 
  e_theme("westeros")
  
# svg path
path <- "path://M0,10 L10,10 C5.5,10 5.5,5 5,0 C4.5,5 4.5,10 0,10 z"

style <- list(
  normal = list(opacity = 0.5), # normal
  emphasis = list(opacity = 1) # on hover
)

df \%>\% 
  e_charts(x) \%>\% 
  e_pictorial(y, symbol = path, barCategoryGap = "-130\%",
    itemStyle = style) 
    
# image
# might not work in RStudio viewer
# open in browser
qomo <- paste0(
  "https://ecomfe.github.io/echarts-examples/public/",
  "data/asset/img/hill-Qomolangma.png"
)

kili <- paste0(
  "https://ecomfe.github.io/echarts-examples/public/", 
  "data/asset/img/hill-Kilimanjaro.png"
)

data <- data.frame(
  x = c("Qomolangma", "Kilimanjaro"), 
  value = c(8844, 5895),
  symbol = c(paste0("image://", qomo),
    paste0("image://", kili))
)

data \%>\% 
  e_charts(x) \%>\% 
  e_pictorial(value, symbol) \%>\% 
  e_legend(FALSE) 

}
\seealso{
\href{Additional arguments}{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-pictorialBar}
}
