% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mean_var_3PLN.R
\name{getMean3PLN}
\alias{getMean3PLN}
\alias{getMean2PLN}
\alias{getVar3PLN}
\alias{getVar2PLN}
\title{Calculate Cumulants Lognormal Response Time Distribution}
\usage{
getMean3PLN(lambda, phi = rep(1, length(lambda)), zeta, sdEpsi)

getMean2PLN(lambda, zeta, sdEpsi)

getVar3PLN(lambda, phi = rep(1, length(lambda)), zeta, sdEpsi)

getVar2PLN(lambda, zeta, sdEpsi)
}
\arguments{
\item{lambda}{Vector of time intensity parameters.}

\item{phi}{[optional] Vector of speed sensitivity parameters.}

\item{zeta}{Vector of person speed parameters.}

\item{sdEpsi}{Vector of item specific residual variances.}
}
\value{
a matrix with either the mean or the variance of the response time distributions,
       with columns for different \code{zeta} and rows for different items
}
\description{
Calculate the first and second cumulants (i.e., mean and variance) of item
response time distributions given item parameters of the three-parameter
log-normal model (3PLN) for response times.
}
\details{
Calculate the first and second cumulant of the two-parameter log-normal (2PLN)
model for response times according to van der Linden (2006) or the 3PLN according
to Klein Entink et al. (2009). If the speed sensitivity parameter \code{phi}
in the 3PLN equals \code{1}, the model reduces to the 2PLN, yet with a
different parameterization for the item specific residual variance \code{sdEpsi}
compared to van der Linden (2006).

The cumulants are computed for one or more speed parameters, and for one or more
sets of item parameters.

The calculation is based on Fenton (1960). For the model by van der Linden (2006), the calculation was
first introduced by van der Linden (2011).
}
\section{Functions}{
\itemize{
\item \code{getMean3PLN()}: Calculate mean 3PLN

\item \code{getMean2PLN()}: Calculate mean 2PLN

\item \code{getVar3PLN()}: Calculate variance 3PLN

\item \code{getVar2PLN()}: Calculate variance 2PLN

}}
\examples{
# expected RT for a single item (van der Linden model)
getMean2PLN(lambda = 3.8, zeta = 0, sdEpsi = 0.3)
getVar2PLN(lambda = 3.8, zeta = 0, sdEpsi = 0.3)

# expected RT for multiple items (van der Linden model)
getMean2PLN(lambda = c(4.1, 3.8, 3.5), zeta = 0,
                   sdEpsi = c(0.3, 0.4, 0.2))
getVar2PLN(lambda = c(4.1, 3.8, 3.5), zeta = 0,
                   sdEpsi = c(0.3, 0.4, 0.2))

# expected RT for multiple items and multiple spped levels (Klein Entink model)
getMean3PLN(lambda = c(3.7, 4.1, 3.8), phi = c(1.1, 0.8, 0.5),
                    zeta = c(-1, 0, 1), sdEpsi = c(0.3, 0.4, 0.2))
getVar3PLN(lambda = c(3.7, 4.1, 3.8), phi = c(1.1, 0.8, 0.5),
                    zeta = c(-1, 0, 1), sdEpsi = c(0.3, 0.4, 0.2))

}
\references{
Fenton, L. (1960). The sum of log-normal probability distributions in scatter transmission systems. \emph{IRE
Transactions on Communication Systems}, 8, 57-67.

Klein Entink, R. H., Fox, J.-P., & van der Linden, W. J. (2009). A multivariate
multilevel approach to the modeling of accuracy and speed of test
takers. \emph{Psychometrika}, 74(1), 21-48.

van der Linden, W. J. (2006). A lognormal model for response times on test
items. \emph{Journal of Educational and Behavioral Statistics, 31(2),
181-204}.

van der Linden, W. J. (2011). Test design and speededness. \emph{Journal of
Educational Measurement}, 48(1), 44-60.
}
