% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EAT.R
\name{EAT_leaf_stats}
\alias{EAT_leaf_stats}
\title{Descriptive Summary Statistics Table for the Leaf Nodes of an Efficiency Analysis Trees model}
\usage{
EAT_leaf_stats(object)
}
\arguments{
\item{object}{An \code{EAT} object.}
}
\value{
A \code{list} or a \code{data.frame} (for 1 output scenario) with the following summary statistics:
\itemize{
  \item{\code{N}: number of observations.}
  \item{\code{Proportion}: proportion of observations.}
  \item{\code{mean}: mean.}
  \item{\code{var}: variance.}   
  \item{\code{sd}: standard deviation.}
  \item{\code{min}: minimun.}
  \item{\code{Q1}: first quartile.}
  \item{\code{median}: median.}
  \item{\code{Q3}: third quartile.}
  \item{\code{max}: maximum.}
  \item{\code{RMSE}: root mean squared error.}
}
}
\description{
This function returns a descriptive summary statistics table for each output variable calculated from the leaf nodes observations of an Efficiency Analysis Trees model. Specifically, it computes the number of observations, the proportion of observations, the mean, the variance, the standard deviation, the minimum, the first quartile, the median, the third quartile, the maximum and the root mean squared error.
}
\examples{
simulated <- Y1.sim(N = 50, nX = 3)
EAT_model <- EAT(data = simulated, x = c(1, 2, 3), y = 4, numStop = 10, fold = 5)
EAT_leaf_stats(EAT_model)

}
