% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyEAT.R
\name{EAT_WAM}
\alias{EAT_WAM}
\title{Weighted Additive Model for an Efficiency Analysis Trees model}
\usage{
EAT_WAM(j, scores, x_k, y_k, atreeTk, ytreeTk, nX, nY, N_leaves, weights)
}
\arguments{
\item{j}{Number of DMUs.}

\item{scores}{\code{matrix}. Empty matrix for scores.}

\item{x_k}{\code{data.frame}. Set of input variables.}

\item{y_k}{\code{data.frame} Set of output variables.}

\item{atreeTk}{\code{matrix} Set of "a" Pareto-coordinates.}

\item{ytreeTk}{\code{matrix} Set of predictions.}

\item{nX}{Number of inputs.}

\item{nY}{Number of outputs.}

\item{N_leaves}{Number of leaf nodes.}

\item{weights}{Character. \code{"MIP"} for Measure of Inefficiency Proportion or \code{"RAM"} for Range Adjusted Measure of Inefficiency.}
}
\value{
A numerical vector with efficiency scores.
}
\description{
Weighted Additive Model for an Efficiency Analysis Trees model.
}
