% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingEAT.R
\name{rankingEAT}
\alias{rankingEAT}
\title{Ranking of Variables by Efficiency Analysis Trees}
\usage{
rankingEAT(object, barplot = TRUE, threshold = 70, digits = 2)
}
\arguments{
\item{object}{An EAT object.}

\item{barplot}{Logical. If \code{TRUE}, a barplot with the importance scores is displayed.}

\item{threshold}{Numeric. Importance score value in which a line is graphed.}

\item{digits}{Integer. Decimal units.}
}
\value{
Dataframe with the importance scores. If \code{barplot = TRUE}, it is returned a list containing the scores and the barplot.
}
\description{
This function calculates variable importance through an Efficiency Analysis Trees model.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

rankingEAT(object = EAT_model,
           barplot = TRUE,
           threshold = 70,
           digits = 2)
}

}
