% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_plots.R
\name{efficiencyJitter}
\alias{efficiencyJitter}
\title{Efficiency Scores Jitter Plot}
\usage{
efficiencyJitter(object, df_scores, scores_model, upb = NULL, lwb = NULL)
}
\arguments{
\item{object}{An EAT object.}

\item{df_scores}{Dataframe with efficiency scores (from \code{efficiencyEAT} or \code{efficiencyCEAT}).}

\item{scores_model}{Mathematical programming model to calculate scores. 
\itemize{
\item{\code{BCC.OUT}} BCC model. Output-oriented.
\item{\code{BCC.INP}}  BCC model. Input-oriented.
\item{\code{DDF}}     Directional Distance Function.
\item{\code{RSL.OUT}} Russell model. Output-oriented.
\item{\code{RSL.INP}}  Russell model. Input-oriented.
\item{\code{WAM.MIP}} Weighted Additive Model. Measure of Inefficiency Proportions.
\item{\code{WAM.RAM}} Weighted Additive Model. Range Adjusted Measure of Inefficiency.
}}

\item{upb}{Numeric. Upper bound for labeling.}

\item{lwb}{Numeric. Lower bound for labeling.}
}
\value{
Jitter plot with DMUs and scores.
}
\description{
This function returns a jitter plot from \code{ggplot2}. This graphic shows how DMUs are grouped into leaf nodes in a model built using the \code{EAT} function. Each leaf node groups DMUs with the same level of resources. The dot and the black line represent, respectively, the mean value and the standard deviation of the scores of its node. Additionally, efficient DMU labels always are displayed based on the model entered in the \code{scores_model} argument. Finally, the user can specify an upper bound \code{upn} and a lower bound \code{lwb} in order to show, in addition, the labels whose efficiency score lies between them.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

EAT_scores <- efficiencyEAT(data = simulated, x = c(1, 2), y = c(3, 4), object = EAT_model,
                            scores_model = "BCC.OUT", digits = 2, na.rm = TRUE)

efficiencyJitter(object = EAT_model, df_scores = EAT_scores, scores_model = "BCC.OUT")
}

}
