% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcol.R
\name{tcol}
\alias{tcol}
\title{Transpose at Column.}
\usage{
tcol(x, header, cols.colname = "col", do.atype = TRUE)
}
\arguments{
\item{x}{Data frame to be transposed.}

\item{header}{Column name/number to be used as column names of transposed data.}

\item{cols.colname}{Name to use for the column of column names in the transposed data.}

\item{do.atype}{Transpose convertes to strings, since data types are uncertain. Run atype to automatically correct variable typing where possible. This will slow the result a bit.}
}
\value{
Transposed data frame.
}
\description{
Transpose operation that sets column names equal to a column in the original data.
Author: Bryce Chamberlain.
}
\examples{
 # create a summary dataset from iris.
 x = dplyr::summarize_at( 
  dplyr::group_by( iris, Species ), 
  dplyr::vars( Sepal.Length, Sepal.Width ), list(sum) 
 )
 # run tcol
 tcol( x, 'Species' )
}
