% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fldict.R
\name{fldict}
\alias{fldict}
\title{Get Data Dictionary for Files in Folder}
\usage{
fldict(folder = NULL, file.list = NULL,
  pattern = "^[^~]+[.](xls[xmb]?|csv|rds|xml)", ignore.case = TRUE,
  recursive = TRUE, ...)
}
\arguments{
\item{folder}{File path of the folder to create a dictionary for. Pass either this or file.list. file.list will override this argument.}

\item{file.list}{List of files to create a combined dictionary for. Pass either this or folder. This will ovveride folder.}

\item{pattern}{Pattern to match files in the folder. By default we use a pattern that matches read.any-compatible data files and skips temporary Office files. Passed to list.files.}

\item{ignore.case}{Ignore case when checking pattern. Passed to list.files.}

\item{recursive}{Check files recursively. Passed to list.files.}

\item{...}{Other arguments to read.any for reading in files. Consider using a first_column_name vector, etc.}
}
\value{
List with the properties:
\item{s}{Summary data of each dataset.}
\item{l}{Line data with a row for each column in each dataset.}
}
\description{
Get information about data files in a folder path. Use dict() on a single data frame or getinfo(0) to explore a single column.
Author: Bryce Chamberlain.
}
\examples{

folder = system.file('extdata', package = 'easyr')
fl = fldict(folder)
names(fl)

fl$sheets
fl$columns

}
