% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EnsErrorss.R
\name{EnsErrorss}
\alias{EnsErrorss}
\alias{EnsMaess}
\alias{EnsMess}
\alias{EnsMsess}
\alias{EnsRmsess}
\title{Ensemble Mean Error Skill scores}
\usage{
EnsErrorss(ens, ens.ref, obs, type)

EnsMess(ens, ens.ref, obs)

EnsMaess(ens, ens.ref, obs)

EnsMsess(ens, ens.ref, obs)

EnsRmsess(ens, ens.ref, obs)
}
\arguments{
\item{ens}{n x k matrix of n forecasts from k ensemble members}

\item{ens.ref}{n x l matrix of m reference forecasts from l ensemble members}

\item{obs}{n verifying observations}

\item{type}{specifying what error metric to compute, one of [me, mae, mse,
  rmse]}
}
\description{
Computes various ensemble mean error skill scores.
\code{EnsMess} computes the mean error, \code{EnsMaess} the mean absolute
error, \code{EnsMsess} the mean squared error, and \code{EnsRmsess} the
square root of the mean squared error (for consistency with the veri
package).
}
\examples{
tm <- toymodel()

## compute RMSE skill score against reference forecast with a bias of +2
EnsErrorss(ens=tm$fcst, ens.ref=tm$fcst + 2, obs=tm$obs, type='rmse')

## compute skill score using veriApply
veriApply("EnsRmsess", fcst=tm$fcst, obs=tm$obs, fcst.ref=tm$fcst + 2)
}
\seealso{
\code{\link{veriApply}}, \code{\link{EnsError}}
}

