% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_geodesic_distances.R
\name{calculate_geodesic_distances}
\alias{calculate_geodesic_distances}
\alias{compute_tented_geodesic_distances}
\title{Calculate geodesic distances between cells in a trajectory}
\usage{
calculate_geodesic_distances(
  trajectory,
  waypoint_cells = NULL,
  waypoint_milestone_percentages = NULL,
  directed = FALSE
)

compute_tented_geodesic_distances(
  trajectory,
  waypoint_cells = NULL,
  waypoint_milestone_percentages = NULL
)
}
\arguments{
\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}

\item{waypoint_cells}{A vector of waypoint cells. Only the geodesic distances between waypoint cells and all other cells will be calculated.}

\item{waypoint_milestone_percentages}{The milestone percentages of non-cell waypoints, containing waypoint_id, milestone_id and percentage columns}

\item{directed}{Take into account the directions of the milestone edges. The cells that cannot be reached from a particular waypoint will have distance infinity. You can also give a character, if it is "forward" it will look forward, if it is "reverse" it will look in the reversed direction}
}
\value{
A matrix containing geodesic distances between each waypoint cell (rows) and cell (columns)
}
\description{
Will calculate geodesic distances between cells within a trajectory. To speed things up, only the distances with a set of waypoint cells are calculated.
}
\details{
The geodesic distance takes into account the length of an edge regions of delayed commitment.
}
\examples{
geodesic_distances <- calculate_geodesic_distances(example_trajectory)
geodesic_distances[1:10, 1:10]

}
\keyword{derive_trajectory}
