% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_prior_information.R
\name{add_prior_information}
\alias{add_prior_information}
\alias{is_wrapper_with_prior_information}
\alias{generate_prior_information}
\title{Add or compute prior information for a trajectory}
\usage{
add_prior_information(
  dataset,
  start_id = NULL,
  end_id = NULL,
  groups_id = NULL,
  groups_network = NULL,
  features_id = NULL,
  groups_n = NULL,
  start_n = NULL,
  end_n = NULL,
  leaves_n = NULL,
  timecourse_continuous = NULL,
  timecourse_discrete = NULL,
  dimred = NULL,
  verbose = TRUE
)

is_wrapper_with_prior_information(dataset)

generate_prior_information(
  cell_ids,
  milestone_ids,
  milestone_network,
  milestone_percentages,
  progressions,
  divergence_regions,
  expression,
  feature_info = NULL,
  cell_info = NULL,
  marker_fdr = 0.005,
  given = NULL,
  verbose = FALSE
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{start_id}{The start cells}

\item{end_id}{The end cells}

\item{groups_id}{The grouping of cells, a dataframe with cell_id and group_id}

\item{groups_network}{The network between groups, a dataframe with from and to}

\item{features_id}{The features (genes) important for the trajectory}

\item{groups_n}{Number of branches}

\item{start_n}{Number of start states}

\item{end_n}{Number of end states}

\item{leaves_n}{Number of leaves}

\item{timecourse_continuous}{The time for every cell}

\item{timecourse_discrete}{The time for every cell in groups}

\item{dimred}{A dimensionality reduction of the cells (see \code{\link[=add_dimred]{add_dimred()}})}

\item{verbose}{Whether or not to print informative messages}

\item{cell_ids}{The identifiers of the cells.}

\item{milestone_ids}{The ids of the milestones in the trajectory. Type: Character vector.}

\item{milestone_network}{The network of the milestones.
Type: Data frame(from = character, to = character, length = numeric, directed = logical).}

\item{milestone_percentages}{A data frame specifying what percentage milestone each cell
consists of.
Type: Data frame(cell_id = character, milestone_id = character, percentage = numeric).}

\item{progressions}{Specifies the progression of a cell along a transition in the milestone_network.
Type: Data frame(cell_id = character, from = character, to = character, percentage = numeric).}

\item{divergence_regions}{A data frame specifying the divergence
regions between milestones (e.g. a bifurcation).
Type: Data frame(divergence_id = character, milestone_id = character, is_start = logical).}

\item{expression}{The normalised expression values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{feature_info}{Optional meta-information pertaining the features.}

\item{cell_info}{Optional meta-information pertaining the cells.}

\item{marker_fdr}{Maximal FDR value for a gene to be considered a marker}

\item{given}{Prior information already calculated}
}
\description{
If you specify

For example, what are the start cells, the end cells, to which milestone does each cell belong to, ...
}
\details{
If the dataset contains a trajectory (see \code{\link[=add_trajectory]{add_trajectory()}}) and expression data, this function will compute and add prior information using \code{\link[=generate_prior_information]{generate_prior_information()}}

The dataset has to contain a trajectory for this to work
}
\examples{
# add some prior information manually
dataset <- example_dataset
dataset <- add_prior_information(dataset, start_id = "Cell1")
dataset$prior_information$start_id

# compute prior information from a trajectory
trajectory <- example_trajectory
trajectory <- add_prior_information(trajectory)
trajectory$prior_information$end_id

}
\keyword{infer_trajectory}
