% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.initial}
\alias{prep.initial}
\title{Recipe function for preparing the initial conditions for the model.}
\usage{
prep.initial(values.inistate, params.inistate, values.inicov, params.inicov,
  values.regimep = 1, params.regimep = 0)
}
\arguments{
\item{values.inistate}{a vector or list of vectors of the starting or fixed values of the initial state vector in one or more regimes.}

\item{params.inistate}{a vector or list of vectors of the parameter names that appear in the initial state vector in one or more regimes. If an element is 0 or "fixed", the corresponding element is fixed at the value specified in the values vector; Otherwise, the corresponding element is to be estimated with the starting value specified in the values vector.}

\item{values.inicov}{a positive definite matrix or a list of positive definite matrices of the starting or fixed values of the initial error covariance structure(s) in one or more regimes. If only one matrix is specified for a regime-switching dynamic model, the initial error covariance structure stays the same across regimes. To ensure the matrix is positive definite in estimation, we apply LDL transformation to the matrix. Values are hence automatically adjusted for this purpose.}

\item{params.inicov}{a matrix or list of matrices of the parameter names that appear in the initial error covariance(s) in one or more regimes. If an element is 0 or "fixed", the corresponding element is fixed at the value specified in the values matrix; Otherwise, the corresponding element is to be estimated with the starting value specified in the values matrix. If only one matrix is specified for a regime-switching dynamic model, the process noise structure stays the same across regimes. If a list is specified, any two sets of the parameter names as in two matrices should be either the same or totally different to ensure proper parameter estimation.}

\item{values.regimep}{a vector of the starting or fixed values of the initial probabilities of being in each regime. By default, the initial probability of being in the first regime is fixed at 1.}

\item{params.regimep}{a vector of the parameter indices of the initial probabilities of
being in each regime. If an element is 0 or "fixed", the corresponding element is fixed at the value
specified in the "values" vector; Otherwise, the corresponding element is to be estimated
with the starting value specified in the values vector.}
}
\description{
Recipe function for preparing the initial conditions for the model.
}
\details{
The initial condition model includes specifications for the intial state vector,
initial error covariance matrix, initial probabilities of
being in each regime and all associated parameter specifications.
}

