% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrModel.R
\name{dynr.model}
\alias{dynr.model}
\title{Create a dynrModel object for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}}
\usage{
dynr.model(dynamics, measurement, noise, initial, data, ...,
  outfile = tempfile())
}
\arguments{
\item{dynamics}{a dynrDynamics object prepared with \code{\link{prep.formulaDynamics}} 
or \code{\link{prep.matrixDynamics}}}

\item{measurement}{a dynrMeasurement object prepared with \code{\link{prep.loadings}} 
or \code{\link{prep.measurement}}}

\item{noise}{a dynrNoise object prepared with \code{\link{prep.noise}}}

\item{initial}{a dynrInitial object prepared with \code{\link{prep.initial}}}

\item{data}{a dynrData object made with \code{\link{dynr.data}}}

\item{...}{additional arguments specifying other dynrRecipe objects. Argument regimes is for 
a dynrRegimes object prepared with \code{\link{prep.regimes}} and argument transform is for 
a dynrTrans object prepared with \code{\link{prep.tfun}}.}

\item{outfile}{a character string of the name of the output C script of model functions to be compiled 
for parameter estimation. The default is the name for a potential temporary file returned by tempfile().}
}
\description{
Create a dynrModel object for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}
}
\details{
A \code{dynrModel} is a collection of recipes.  The recipes are constructed with the functions \code{\link{prep.measurement}}, \code{\link{prep.noise}}, \code{\link{prep.formulaDynamics}}, \code{\link{prep.matrixDynamics}}, \code{\link{prep.initial}}, and in the case of regime-switching models \code{\link{prep.regimes}}.  Additionally, data must be prepared with \code{\link{dynr.data}} and added to the model.

Several \emph{named} arguments can be passed into the \code{...} section of the function.  These include
\itemize{
	\item Argument \code{regimes} is for a dynrRegimes object prepared with \code{\link{prep.regimes}}
	\item Argument \code{transform} is for a dynrTrans object prepared with \code{\link{prep.tfun}}.
	\item Argument \code{options} a list of options. Check the NLopt website \url{http://ab-initio.mit.edu/wiki/index.php/NLopt_Reference#Stopping_criteria} 
for details. Available options for use with a dynrModel object 
include xtol_rel, stopval, ftol_rel, ftol_abs, maxeval, and maxtime, 
all of which control the termination conditions for parameter optimization. The examples below show a case where options were set.
}

There are several available methods for \code{dynrModel} objects.
\itemize{
	\item The dollar sign ($) can be used to both get objects out of a model and to set pieces of the model.
	\item \code{names} returns the names of the free parameters in a model.
	\item \code{\link{printex}} prints LaTeX expressions for the equations that compose a model. The output can then be readily typeset for inclusion in presentations and papers.
	\item \code{nobs} gives the total number of observations (e.g. all times across all people)
	\item \code{coef} gives the free parameter starting values.  Free parameters can also be assigned with \code{coef(model) <- aNamedVectorOfCoefficients}
}
}
\examples{
#rsmod <- dynr.model(dynamics=recDyn, measurement=recMeas, noise=recNoise, 
#    initial=recIni, regimes=recReg, data=dd, outfile="RSLinearDiscrete.c")

#Set relative tolerance on function value via 'options':
#rsmod <- dynr.model(dynamics=recDyn, measurement=recMeas, noise=recNoise, 
#    initial=recIni, regimes=recReg, data=dd, outfile="RSLinearDiscrete.c",
#    options=list(ftol_rel=as.numeric(1e-6)))

#For a full demo example, see:
#demo(RSLinearDiscrete , package="dynr")
}

