% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.matrixDynamics}
\alias{prep.matrixDynamics}
\title{Recipe function for creating Linear Dynamcis using matrices}
\usage{
prep.matrixDynamics(params.dyn = NULL, values.dyn, params.exo = NULL,
  values.exo = NULL, params.int = NULL, values.int = NULL, covariates,
  isContinuousTime)
}
\arguments{
\item{params.dyn}{the matrix of parameter names for the transition matrix in the 
specified linear dynamic model}

\item{values.dyn}{the matrix of starting/fixed values for the transition matrix in the 
specified linear dynamic model}

\item{params.exo}{the matrix of parameter names for the regression slopes of covariates on the latent variables (see details)}

\item{values.exo}{matrix of starting/fixed values for the regression slopes of covariates on the latent variables (see details)}

\item{params.int}{vector of names for intercept parameters in the dynamic model specified as a matrix or list of matrices.}

\item{values.int}{vector of intercept values in the dynamic model specified as matrix or list of matrices. Contains starting/fixed values of the intercepts.}

\item{covariates}{the names or the index numbers of the covariates used in the dynamic model}

\item{isContinuousTime}{logical. When TRUE, use a continuous time model.  When FALSE use a discrete time model.}
}
\description{
Recipe function for creating Linear Dynamcis using matrices
}
\details{
A recipe function for specifying the deterministic portion of a set of linear dynamic functions as:

Discrete-time model: eta(t+1) = int + dyn*eta(t) + exo*x(t), 
where eta(t) is a vector of latent variables, x(t) is a vector of covariates,
int, dyn, and exo are vectors and matrices specified via the arguments *.int, *.dyn, and *.exo. 

Continuous-time model: d/dt eta(t) = int + dyn*eta(t) + exo*x(t), 
where eta(t) is a vector of latent variables, x(t) is a vector of covariates,
int, dyn, and exo are vectors and matrices specified via the arguments *.int, *.dyn, and *.exo.

The left-hand side of the dynamic model consists of a vector of latent variables for the next time point in the discrete-time case,
and the vector of derivatives for the latent variables at the current time point in the continuous-time case.

For models with regime-switching dynamic functions, the user will need to provide a list of the *.int, *.dyn, and *.exo arguments. 
(when they are specified to take on values other than the default of zero vectors and matrices), or if a single set of vectors/matrices are provided, the same 
vectors/matrices are assumed to hold across regimes.

\code{prep.matrixDynamics} serves as an alternative to \code{\link{prep.formulaDynamics}}.
}
\examples{
#Single-regime, continuous-time model. For further details run: 
#demo(RSNonlinearDiscrete, package="dynr"))
dynamics <- prep.matrixDynamics(
values.dyn=matrix(c(0, -0.1, 1, -0.2), 2, 2),
params.dyn=matrix(c('fixed', 'spring', 'fixed', 'friction'), 2, 2),
isContinuousTime=TRUE)

#Two-regime, continuous-time model. For further details run: 
#demo(RSNonlinearDiscrete, package="dynr"))
dynamics <- prep.matrixDynamics(
values.dyn=list(matrix(c(0, -0.1, 1, -0.2), 2, 2),
                matrix(c(0, -0.1, 1, 0), 2, 2)),
params.dyn=list(matrix(c('fixed', 'spring', 'fixed', 'friction'), 2, 2),
           matrix(c('fixed', 'spring', 'fixed', 'fixed'), 2, 2)),
isContinuousTime=TRUE) 
}
\seealso{
Methods that can be used include: \code{\link{print}}, \code{\link{show}}
}

