% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{splines}
\alias{splines}
\title{Define the B-splines Used for the Time-varying Coefficients of the Model.}
\usage{
splines(
  df = NULL,
  degree = 3L,
  lb_tau = 0,
  noncentered = FALSE,
  override = FALSE
)
}
\arguments{
\item{df}{[\code{integer(1)}]\cr Degrees of freedom, i.e., the total number of
spline coefficients. See \code{\link[splines:bs]{splines::bs()}}. Note that the knots are always
defined as an equidistant sequence on the interval starting from the first
non-fixed time point to the last time point in the data. See
\code{\link[=dynamiteformula]{dynamiteformula()}} for more information on fixed time points.
Should be an (unrestricted) positive integer.}

\item{degree}{[\code{integer(1)}]\cr See \code{\link[splines:bs]{splines::bs()}}. Should be an
(unrestricted) positive integer.}

\item{lb_tau}{[\code{numeric()}]\cr Hard constraint(s) on the lower bound of the
standard deviation parameters \eqn{\tau} of the random walk priors. Can be
useful in avoiding divergences in some cases. See also the \code{noncentered}
argument. Can be a single positive value, or vector defining the
lower bound separately for each channel, even for channels without
varying effects. The ordering is based on the order of channel definitions
in the \code{dynamiteformula} object.}

\item{noncentered}{[\code{logical()}]\cr If \code{TRUE}, use a noncentered
parameterization for the spline coefficients. Default is \code{FALSE}. Try
changing this if you encounter divergences or other problems in sampling
for example when simulating from prior predictive distribution.
Can be a single logical value, or vector of logical values, defining the
parameterization separately for each channel, even for channels without
varying effects.}

\item{override}{[\code{logical(1)}]\cr If \code{FALSE} (the default), an existing
definition for the splines will not be overridden by another call to
\code{splines()}. If \code{TRUE}, any existing definitions will be replaced.}
}
\value{
An object of class \code{splines}.
}
\description{
This function can be used as part of \code{\link[=dynamiteformula]{dynamiteformula()}} to define the
splines used for the time-varying coefficients \eqn{\delta}.
}
\examples{
data.table::setDTthreads(1) # For CRAN
# Two channel model with varying effects, with explicit lower bounds for the
# random walk prior standard deviations, with noncentered parameterization
# for the first channel and centered for the second channel.
obs(y ~ 1, family = "gaussian") + obs(x ~ 1, family = "gaussian") +
  lags(type = "varying") +
  splines(
    df = 20, degree = 3, lb_tau = c(0, 0.1),
    noncentered = c(TRUE, FALSE)
  )

}
\seealso{
Model formula construction
\code{\link{dynamiteformula}()},
\code{\link{dynamite}()},
\code{\link{lags}()},
\code{\link{lfactor}()},
\code{\link{random_spec}()}
}
\concept{formulas}
