% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_frame.R
\name{as.data.frame.dynamitefit}
\alias{as.data.frame.dynamitefit}
\title{Extract Samples From a \code{dynamitefit} Object as a Data Frame}
\usage{
\method{as.data.frame}{dynamitefit}(
  x,
  row.names = NULL,
  optional = FALSE,
  parameters = NULL,
  responses = NULL,
  types = NULL,
  summary = FALSE,
  probs = c(0.05, 0.95),
  include_fixed = TRUE,
  ...
)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{row.names}{Ignored.}

\item{optional}{Ignored.}

\item{parameters}{[\code{character()}]\cr Parameter(s) for which the samples
should be extracted. Possible options can be found with function
\code{get_parameter_names()}. Default is all parameters of specific type for all
responses.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.
Ignored if the argument \code{parameters} is supplied.}

\item{types}{[\code{character()}]\cr Type(s) of the parameters for which the
samples should be extracted. See details of possible values. Default is
all values listed in details except spline coefficients \code{omega},
\code{omega_alpha}, and \code{omega_psi}. See also \code{\link[=get_parameter_types]{get_parameter_types()}}.
Ignored if the argument \code{parameters} is supplied.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE}, returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE} (default), returns the
posterior samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{include_fixed}{[\code{logical(1)}]\cr If \code{TRUE} (default), time-varying
parameters for \code{1:fixed} time points are included in the output as \code{NA}
values. If \code{FALSE}, fixed time points are omitted completely
from the output.}

\item{...}{Ignored.}
}
\value{
A \code{tibble} containing either samples or summary statistics of the
model parameters in a long format. For a wide format, see
\code{\link[=as_draws]{as_draws()}}.
}
\description{
Provides a \code{data.frame} representation of the posterior samples of the model
parameters.
}
\details{
The arguments \code{responses} and \code{types} can be used to extract only a subset
of the model parameters (i.e., only certain types of parameters related to a
certain response variable).

Potential values for the \code{types} argument are:
\itemize{
\item \code{alpha}\cr Intercept terms (time-invariant or time-varying).
\item \code{beta}\cr Time-invariant regression coefficients.
\item \code{delta}\cr Time-varying regression coefficients.
\item \code{nu}\cr Group-level random effects.
\item \code{lambda}\cr Factor loadings.
\item \code{psi}\cr Latent factors.
\item \code{tau}\cr Standard deviations of the spline coefficients of \code{delta}.
\item \code{tau_alpha}\cr Standard deviations of the spline coefficients of
time-varying \code{alpha}.
\item \code{sigma_nu}\cr Standard deviations of the random effects \code{nu}.
\item \code{corr_nu}\cr Pairwise within-group correlations of random effects \code{nu}.
Samples of the full correlation matrix can be extracted manually as
\code{rstan::extract(fit$stanfit, pars = "corr_matrix_nu")} if necessary.
\item \code{sigma_lambda}\cr Standard deviations of the latent factor loadings
\code{lambda}.
\item \code{tau_psi}\cr Standard deviations of the the spline coefficients of \code{psi}.
\item \code{corr_psi}\cr Pairwise correlations of the latent factors.
Samples of the full correlation matrix can be extracted manually as
\code{rstan::extract(fit$stanfit, pars = "corr_matrix_psi")} if necessary.
\item \code{sigma}\cr Standard deviations of gaussian responses.
\item \code{corr}\cr Pairwise correlations of multivariate gaussian responses.
\item \code{phi}\cr Describes various distributional parameters, such as:
\itemize{
\item Dispersion parameter of the Negative Binomial distribution.
\item Shape parameter of the Gamma distribution.
\item Precision parameter of the Beta distribution.
\item Degrees of freedom of the Student t-distribution.
}
\item \code{omega}\cr Spline coefficients of the regression coefficients \code{delta}.
\item \code{omega_alpha}\cr Spline coefficients of time-varying \code{alpha}.
\item \code{omega_psi}\cr Spline coefficients of the latent factors \code{psi}.
}
}
\examples{
data.table::setDTthreads(1) # For CRAN
as.data.frame(
  gaussian_example_fit,
  responses = "y",
  types = "beta"
)

# Basic summaries can be obtained automatically with summary = TRUE
as.data.frame(
  gaussian_example_fit,
  responses = "y",
  types = "beta",
  summary = TRUE
)

# Time-varying coefficients "delta"
as.data.frame(
  gaussian_example_fit,
  responses = "y",
  types = "delta",
  summary = TRUE
)

# Obtain summaries for a specific parameters
as.data.frame(
  gaussian_example_fit,
  parameters = c("tau_y_x", "sigma_y"),
  summary = TRUE
)

}
\seealso{
Model outputs
\code{\link{as.data.table.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{coef.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_names}()},
\code{\link{get_parameter_types}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
