% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{confint.dynamitefit}
\alias{confint.dynamitefit}
\title{Credible Intervals for Dynamite Model Parameters}
\usage{
\method{confint}{dynamitefit}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{parm}{Ignored.}

\item{level}{[\code{numeric(1)}]\cr Credible interval width.}

\item{...}{Ignored.}
}
\value{
The rows of the resulting matrix will be named using the following
logic: \verb{\{parameter\}_\{time\}_\{category\}_\{group\}} where \code{parameter} is the
name of the parameter, \code{time} is the time index of the parameter,
\code{category} specifies the level of the response the parameter
is related to if the response is categorical, and \code{group} determines which
group of observations the parameter is related to in the case of random
effects and loadings. Non-applicable fields in the this syntax are set
to \code{NA}.
}
\description{
Credible Intervals for Dynamite Model Parameters
}
\examples{
confint(gaussian_example_fit, level = 0.9)

}
