% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamite-package.R
\docType{data}
\name{gaussian_example_fit}
\alias{gaussian_example_fit}
\title{Model Fit for the Simulated Data of Gaussian Responses}
\format{
A \code{dynamitefit} object.
}
\source{
The data was generated according to a script in
\url{https://github.com/ropensci/dynamite/blob/main/data-raw/gaussian_example_fit.R}
}
\usage{
gaussian_example_fit
}
\description{
A \code{dynamitefit} object obtained by running \code{dynamite} on the
\code{gaussian_example} dataset as
\preformatted{
set.seed(1)
library(dynamite)
gaussian_example_fit <- dynamite(
  obs(y ~ -1 + z + varying(~ x + lag(y)), family = "gaussian") +
  random() + splines(df = 20),
  data = gaussian_example, time = "time", group = "id",
  iter = 2000, warmup = 1000, thin = 10,
  chains = 2, cores = 2, refresh = 0, save_warmup = FALSE,
  pars = c("omega_alpha_1_y", "omega_raw_alpha_y", "nu_raw", "nu", "L"),
  include = FALSE
)
}
Note the very small number of samples due to size restrictions on CRAN.
}
\keyword{datasets}
