//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/core_functions/scalar/map_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct CardinalityFun {
	static constexpr const char *Name = "cardinality";
	static constexpr const char *Parameters = "map";
	static constexpr const char *Description = "Returns the size of the map (or the number of entries in the map)";
	static constexpr const char *Example = "cardinality( map([4, 2], ['a', 'b']) );";

	static ScalarFunction GetFunction();
};

struct MapFun {
	static constexpr const char *Name = "map";
	static constexpr const char *Parameters = "keys,values";
	static constexpr const char *Description = "Creates a map from a set of keys and values";
	static constexpr const char *Example = "map(['key1', 'key2'], ['val1', 'val2'])";

	static ScalarFunction GetFunction();
};

struct MapEntriesFun {
	static constexpr const char *Name = "map_entries";
	static constexpr const char *Parameters = "map";
	static constexpr const char *Description = "Returns the map entries as a list of keys/values";
	static constexpr const char *Example = "map_entries(map(['key'], ['val']))";

	static ScalarFunction GetFunction();
};

struct MapExtractFun {
	static constexpr const char *Name = "map_extract";
	static constexpr const char *Parameters = "map,key";
	static constexpr const char *Description = "Returns a list containing the value for a given key or an empty list if the key is not contained in the map. The type of the key provided in the second parameter must match the type of the map’s keys else an error is returned";
	static constexpr const char *Example = "map_extract(map(['key'], ['val']), 'key')";

	static ScalarFunction GetFunction();
};

struct ElementAtFun {
	using ALIAS = MapExtractFun;

	static constexpr const char *Name = "element_at";
};

struct MapFromEntriesFun {
	static constexpr const char *Name = "map_from_entries";
	static constexpr const char *Parameters = "map";
	static constexpr const char *Description = "Returns a map created from the entries of the array";
	static constexpr const char *Example = "map_from_entries([{k: 5, v: 'val1'}, {k: 3, v: 'val2'}]);";

	static ScalarFunction GetFunction();
};

struct MapConcatFun {
	static constexpr const char *Name = "map_concat";
	static constexpr const char *Parameters = "any,...";
	static constexpr const char *Description = "Returns a map created from merging the input maps, on key collision the value is taken from the last map with that key";
	static constexpr const char *Example = "map_concat(map([1,2], ['a', 'b']), map([2,3], ['c', 'd']));";

	static ScalarFunction GetFunction();
};

struct MapKeysFun {
	static constexpr const char *Name = "map_keys";
	static constexpr const char *Parameters = "map";
	static constexpr const char *Description = "Returns the keys of a map as a list";
	static constexpr const char *Example = "map_keys(map(['key'], ['val']))";

	static ScalarFunction GetFunction();
};

struct MapValuesFun {
	static constexpr const char *Name = "map_values";
	static constexpr const char *Parameters = "map";
	static constexpr const char *Description = "Returns the values of a map as a list";
	static constexpr const char *Example = "map_values(map(['key'], ['val']))";

	static ScalarFunction GetFunction();
};

} // namespace duckdb
