% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-tsclustFamily.R
\docType{class}
\name{tsclustFamily-class}
\alias{tsclustFamily-class}
\alias{tsclustFamily}
\title{Class definition for \code{tsclustFamily}}
\description{
Formal S4 class with a family of functions used in \code{\link[=tsclust]{tsclust()}}.
}
\details{
The custom implementations also handle parallelization.

Since the distance function makes use of \pkg{proxy}, it also supports any extra \code{\link[proxy:dist]{proxy::dist()}}
parameters in \code{...}.

The prototype includes the \code{cluster} function for partitional methods, as well as a pass-through
\code{preproc} function. The initializer expects a control from \link{tsclust-controls}. See more below.
}
\section{Slots}{

\describe{
\item{\code{dist}}{The function to calculate the distance matrices.}

\item{\code{allcent}}{The function to calculate centroids on each iteration.}

\item{\code{cluster}}{The function used to assign a series to a cluster.}

\item{\code{preproc}}{The function used to preprocess the data (relevant for \code{\link[stats:predict]{stats::predict()}}).}
}}

\note{
This class is meant to group together the relevant functions, but they are \strong{not} linked with
each other automatically. In other words, neither \code{dist} nor \code{allcent} apply \code{preproc}. They
essentially don't know of each other's existence.
}
\section{Distance function}{


The family's dist() function works like \code{\link[proxy:dist]{proxy::dist()}} but supports parallelization and
optimized symmetric calculations. If you like, you can use the function more or less directly,
but provide a control argument when creating the family (see examples). However, bear in mind
the following considerations.
\itemize{
\item The second argument is called \code{centroids} (inconsistent with \code{\link[proxy:dist]{proxy::dist()}}).
\item If \code{control$distmat} is \emph{not} \code{NULL}, the function will try to subset it.
\item If \code{control$symmetric} is \code{TRUE}, \code{centroids} is \code{NULL}, \emph{and} there is no argument
\code{pairwise} that is \code{TRUE}, only half the distance matrix will be computed.
\itemize{
\item If the distance was registered in \link[proxy:pr_DB]{proxy::pr_DB} with \code{loop = TRUE} and more than one
parallel worker is detected, the computation will be in parallel (using multi-processing with
\code{\link[foreach:foreach]{foreach::foreach()}}), otherwise it will be sequential with \code{\link[proxy:dist]{proxy::dist()}}.
}
\item The function always returns a \code{crossdist} matrix.
}

Note that all distances implemented as part of \pkg{dtwclust} have custom proxy loops that use
multi-threading independently of \pkg{foreach}, so see their respective documentation to see
what optimizations apply to each one.

For distances \emph{not} included in \pkg{dtwclust}, the symmetric, parallel case mentioned above
makes chunks for parallel workers, but they are not perfectly balanced, so some workers might
finish before the others.
}

\section{Centroid function}{


The default partitional allcent() function is a closure with the implementations of the
included centroids. The ones for \code{\link[=DBA]{DBA()}}, \code{\link[=shape_extraction]{shape_extraction()}} and \code{\link[=sdtw_cent]{sdtw_cent()}} can use
multi-process parallelization with \code{\link[foreach:foreach]{foreach::foreach()}}. Its formal arguments are described in
the Centroid Calculation section from \code{\link[=tsclust]{tsclust()}}.
}

\examples{

\dontrun{
data(uciCT)
# See "GAK" documentation
fam <- new("tsclustFamily", dist = "gak")

# This is done with symmetric optimizations, regardless of control$symmetric
crossdist <- fam@dist(CharTraj, window.size = 18L)

# This is done without symmetric optimizations, regardless of control$symmetric
crossdist <- fam@dist(CharTraj, CharTraj, window.size = 18L)

# For non-dtwclust distances, symmetric optimizations only apply
# with an appropriate control AND a single data argument:
fam <- new("tsclustFamily", dist = "dtw",
           control = partitional_control(symmetric = TRUE))
fam@dist(CharTraj[1L:5L])

# If you want the fuzzy family, use fuzzy = TRUE
ffam <- new("tsclustFamily", control = fuzzy_control(), fuzzy = TRUE)
}

}
\seealso{
\code{\link[=dtw_basic]{dtw_basic()}}, \code{\link[=dtw_lb]{dtw_lb()}}, \code{\link[=gak]{gak()}}, \code{\link[=lb_improved]{lb_improved()}}, \code{\link[=lb_keogh]{lb_keogh()}}, \code{\link[=sbd]{sbd()}}, \code{\link[=sdtw]{sdtw()}}.
}
