% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathComb.R
\name{transform_math}
\alias{transform_math}
\title{Mathematical transformations for biomarkers.}
\usage{
transform_math(markers, transform)
}
\arguments{
\item{markers}{a \code{numeric} data frame that contains the biomarkers}

\item{transform}{a \code{numeric} string specifying the method used for transform
the markers. The available methods are: \code{log} \code{exp} \code{sin} \code{cos}.}
}
\value{
A \code{numeric} dataframe of standardized biomarkers
}
\description{
The \code{transform_math} function applies a user preference
transformation from \code{log} \code{exp} \code{sin} \code{cos} transformations
for biomarkers.
}
\examples{
data(exampleData1)
markes <- exampleData1[, -1]
transform_math(markes, transform = "log")

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
