% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repDS.R
\name{repDS}
\alias{repDS}
\title{repDS called by ds.rep}
\usage{
repDS(
  x1.transmit,
  times.transmit,
  length.out.transmit,
  each.transmit,
  x1.includes.characters,
  source.x1,
  source.times,
  source.length.out,
  source.each
)
}
\arguments{
\item{x1.transmit}{This argument determines the input scalar, vector or list.
for behaviour see help for \code{ds.rep} and "details from native R
help for <rep>" (see above). This parameter is usually fully defined by
the argument <x1> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{times.transmit}{This argument determines the number of replications
and the pattern of these replications of the input scalar/vector to
construct the output repetitive sequence.
For behaviour see help for \code{ds.rep} and "details from native R
help for <rep>" (see above). This parameter is usually fully defined by
the argument <times> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{length.out.transmit}{This argument fixes the length of
the output repetive sequence vector
For behaviour see help for \code{ds.rep} and "details from native R
help for <rep>" (see above). This parameter is usually fully defined by
the argument <length.out> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{each.transmit}{This argument specifies the number of replications
of individual elements rather than replications of the full sequence.
For behaviour see help for \code{ds.rep} and "details from native R
help for <rep>" (see above). This parameter is usually fully defined by
the argument <each> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{x1.includes.characters}{Boolean parameter determining
whether to coerce the final output sequence to numeric. Defaults
to FALSE and output is coerced to numeric.
For detailed behaviour see help for \code{ds.rep}.
This parameter is usually fully defined by
the argument <x1.includes.characters> in the call to \code{ds.rep} that
itself calls \code{repDS}.}

\item{source.x1}{This defines the source of the scalar or vector defined
by the <x1> argument. Four character strings are allowed:
"clientside" or "c" and serverside or "s".
For behaviour see help for \code{ds.rep} and "details from native R
help for <rep>" (see above). This parameter is usually fully defined by
the argument <source.x1> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{source.times}{see "param source.x1"
This parameter is usually fully defined by
the argument <source.times> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{source.length.out}{see "param source.x1"
This parameter is usually fully defined by
the argument <source.length.out> in the call to \code{ds.rep} that itself calls \code{repDS}.}

\item{source.each}{see "param source.x1"
This parameter is usually fully defined by
the argument <source.each> in the call to \code{ds.rep} that itself calls \code{repDS}.}
}
\value{
the vector containing the specified repetitive sequence
and write to the output object defined by the <newobj> argument
(or default name seq.vect) which is written to the serverside in 
each source. In addition, two validity messages are returned
indicating whether <newobj> has been created in each data source and if so whether
it is in a valid form. If its form is not valid in at least one study - e.g. because
a disclosure trap was tripped and creation of the full output object was blocked -
ds.matrixDiag also returns any studysideMessages that can explain the error in creating
the full output object. As well as appearing on the screen at run time,if you wish to
see the relevant studysideMessages at a later date you can use the \code{ds.message}
function. If you type ds.message("newobj") it will print out the relevant
studysideMessage from any datasource in which there was an error in creating <newobj>
and a studysideMessage was saved. If there was no error and <newobj> was created
without problems no studysideMessage will have been saved and ds.message("newobj")
will return the message: "ALL OK: there are no studysideMessage(s) on this datasource".
}
\description{
An assign function which
creates a repetitive sequence by repeating
an identified scalar, or specified elements of a vector
or list. This is analogous to the \code{rep} function in native R.
The sequence is written as a new object to the serverside
}
\details{
Further details can be found in the help details
for on ds.rep and the following aspects of the help for
the function \code{rep} in native R also apply (as explained
in more detail with exceptions identified in help for \code{ds.rep}):

In addition a Details from R help for <rep>:

The default behaviour is as if the call was 
rep(x, times = 1, length.out = NA, each = 1)
Normally just one of the additional arguments is specified, but if 'each' is
specified with either of the other two, its replication is performed first, and
then that is followed by the replication implied by times or length.out.

If times consists of a single integer, the result consists of the whole input
repeated this many times. If times is a vector of the same length as x (after
replication by each), the result consists of x[1] repeated times[1] times, x[2]
repeated times[2] times and so on. ***Note exception 1 above.

length.out may be given in place of times, in which case x is repeated as many
times as is necessary to create a vector of this length. If both are given,
length.out takes priority and times is ignored. ***Note exception 3 above.

Non-integer values of times will be truncated towards zero. If times is a
computed quantity it is prudent to add a small fuzz or use round. And analogously
for each.
}
\author{
Paul Burton for DataSHIELD Development Team, 14/10/2019
}
