% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_util_fun.R
\name{text_to_chars}
\alias{text_to_chars}
\alias{str2vec}
\title{Split string(s) of text \code{x} into its characters.}
\usage{
text_to_chars(x, rm_specials = FALSE, sep = "")
}
\arguments{
\item{x}{A string of text (required).}

\item{rm_specials}{Boolean: Remove special characters? 
Default: \code{rm_specials = TRUE}.}

\item{sep}{Character to insert between the elements 
of a multi-element character vector as input \code{x}? 
Default: \code{sep = ""} (i.e., add nothing).}
}
\value{
A character vector (containing individual characters).
}
\description{
\code{text_to_chars} splits a string of text \code{x} 
(consisting of one or more character strings) 
into a vector of its individual characters.
}
\details{
If \code{rm_specials = TRUE}, 
most special (or non-word) characters are 
removed. (Note that this currently works 
without using regular expressions.)

\code{text_to_chars} is an inverse function of \code{\link{chars_to_text}}.
}
\examples{
s3 <- c("A 1st sentence.", "The 2nd sentence.",
        "A 3rd --- and  FINAL --- sentence.")
text_to_chars(s3)
text_to_chars(s3, sep = "\n")
text_to_chars(s3, rm_specials = TRUE) 

}
\seealso{
\code{\link{chars_to_text}} for combining character vectors into text; 
\code{\link{text_to_sentences}} for splitting text into a vector of sentences; 
\code{\link{text_to_words}} for splitting text into a vector of words; 
\code{\link{count_chars}} for counting the frequency of characters; 
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
