% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{map_text_regex}
\alias{map_text_regex}
\title{Map text to character table (allowing for matching patterns).}
\usage{
map_text_regex(
  x = NA,
  file = "",
  lbl_hi = NA,
  lbl_lo = NA,
  bg_hi = NA,
  bg_lo = "[[:space:]]",
  lbl_rotate = NA,
  case_sense = TRUE,
  lbl_tiles = TRUE,
  col_lbl = "black",
  col_lbl_hi = pal_ds4psy[[1]],
  col_lbl_lo = pal_ds4psy[[9]],
  col_bg = pal_ds4psy[[7]],
  col_bg_hi = pal_ds4psy[[4]],
  col_bg_lo = "white",
  col_sample = FALSE,
  angle_fg = c(-90, 90),
  angle_bg = 0
)
}
\arguments{
\item{x}{The text to map or plot (as a character vector). 
Different elements denote different lines of text. 
If \code{x = NA} (as per default), 
the \code{file} argument is used to read 
a text file or user input from the Console.}

\item{file}{A text file to read (or its path). 
If \code{file = ""} (as per default), 
\code{scan} is used to read user input from the Console. 
If a text file is stored in a sub-directory, 
enter its path and name here (without any leading or 
trailing "." or "/").}

\item{lbl_hi}{Labels to highlight (as regex). 
Default: \code{lbl_hi = NA}.}

\item{lbl_lo}{Labels to de-emphasize (as regex). 
Default: \code{lbl_lo = NA}.}

\item{bg_hi}{Background tiles to highlight (as regex). 
Default: \code{bg_hi = NA}.}

\item{bg_lo}{Background tiles to de-emphasize (as regex). 
Default: \code{bg_lo = "[[:space:]]"}.}

\item{lbl_rotate}{Labels to rotate (as regex). 
Default: \code{lbl_rotate = NA}.}

\item{case_sense}{Boolean: Distinguish 
lower- vs. uppercase characters in pattern matches? 
Default: \code{case_sense = TRUE}.}

\item{lbl_tiles}{Are character labels shown? 
This enables pattern matching for (fg) color and 
angle aesthetics. 
Default: \code{lbl_tiles = TRUE} (i.e., show labels).}

\item{col_lbl}{Default color of text labels.
Default: \code{col_lbl = "black"}.}

\item{col_lbl_hi}{Highlighting color of text labels.
Default: \code{col_lbl_hi = pal_ds4psy[[1]]}.}

\item{col_lbl_lo}{De-emphasizing color of text labels.
Default: \code{col_lbl_lo = pal_ds4psy[[9]]}.}

\item{col_bg}{Default color to fill background tiles.
Default: \code{col_bg = pal_ds4psy[[7]]}.}

\item{col_bg_hi}{Highlighting color to fill background tiles.
Default: \code{col_bg_hi = pal_ds4psy[[4]]}.}

\item{col_bg_lo}{De-emphasizing color to fill background tiles.
Default: \code{col_bg_lo = "white"}.}

\item{col_sample}{Boolean: Sample color vectors (within category)?
Default: \code{col_sample = FALSE}.}

\item{angle_fg}{Angle(s) for rotating character labels 
matching the pattern of the \code{lbl_rotate} expression. 
Default: \code{angle_fg = c(-90, 90)}. 
If \code{length(angle_fg) > 1}, a random value 
in uniform \code{range(angle_fg)} is used for every character.}

\item{angle_bg}{Angle(s) of rotating character labels 
not matching the pattern of the \code{lbl_rotate} expression. 
Default: \code{angle_bg = 0} (i.e., no rotation). 
If \code{length(angle_bg) > 1}, a random value 
in uniform \code{range(angle_bg)} is used for every character.}
}
\value{
A data frame describing a plot.
}
\description{
\code{map_text_regex} parses text (from a file or user input) 
into a data frame that contains a row for each 
character of \code{x}.
}
\details{
\code{map_text_regex} allows for regular expression (regex) 
to match text patterns and create corresponding variables 
(e.g., for color or orientation). 

Five regular expressions and corresponding 
color and angle arguments allow identifying, 
marking (highlighting or de-emphasizing), and rotating 
those sets of characters (i.e, their text labels or fill colors).
that match the provided patterns. 

The plot generated by \code{plot_chars} is character-based: 
Individual characters are plotted at equidistant x-y-positions 
and the aesthetic settings provided for text labels and tile fill colors.

\code{map_text_regex} returns a plot description (as a data frame). 
Using this output as an input to \code{\link{plot_charmap}} plots 
text in a character-based fashion (i.e., individual characters are 
plotted at equidistant x-y-positions). 
Together, both functions replace the over-specialized 
\code{\link{plot_chars}} and \code{\link{plot_text}} functions.
}
\examples{
## (1) From text string(s): 
ts <- c("Hello world!", "This is a test to test this splendid function",
        "Does this work?", "That's good.", "Please carry on.")
sum(nchar(ts))

# (a) simple use:
map_text_regex(ts) 

# (b) matching patterns (regex):
map_text_regex(ts, lbl_hi = "\\\\b\\\\w{4}\\\\b", bg_hi = "[good|test]",
               lbl_rotate = "[^aeiou]", angle_fg = c(-45, +45))

## (2) From user input:
# map_text_regex()  # (enter text in Console)
 
## (3) From text file:
# cat("Hello world!", "This is a test file.",
#     "Can you see this text?",
#     "Good! Please carry on...",
#     file = "test.txt", sep = "\n")
# 
# map_text_regex(file = "test.txt")  # default
# map_text_regex(file = "test.txt", lbl_hi = "[[:upper:]]", lbl_lo = "[[:punct:]]",
#                col_lbl_hi = "red", col_lbl_lo = "blue")
# 
# map_text_regex(file = "test.txt", lbl_hi = "[aeiou]", col_lbl_hi = "red",
#                col_bg = "white", bg_hi = "see")  # mark vowels and "see" (in bg)
# map_text_regex(file = "test.txt", bg_hi = "[aeiou]", col_bg_hi = "gold")  # mark (bg of) vowels
# 
# # Label options:
# map_text_regex(file = "test.txt", bg_hi = "see", lbl_tiles = FALSE)
# map_text_regex(file = "test.txt", angle_bg = c(-20, 20))
# 
# unlink("test.txt")  # clean up (by deleting file). 

}
\seealso{
\code{\link{map_text_coord}} for mapping text to a table of character coordinates; 
\code{\link{plot_charmap}} for plotting character maps; 
\code{\link{plot_chars}} for creating and plotting character maps; 
\code{\link{plot_text}} for plotting characters and color tiles by frequency; 
\code{\link{read_ascii}} for reading text inputs into a character string.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
