% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_date}
\alias{sample_date}
\title{Draw a sample of n random dates (from a given range).}
\usage{
sample_date(from = "1970-01-01", to = Sys.Date(), size = 1, ...)
}
\arguments{
\item{from}{Earliest date (as "Date" or string). 
Default: \code{from = "1970-01-01"} 
(as a scalar).}

\item{to}{Latest date (as "Date" or string). 
Default: \code{to = Sys.Date()} 
(as a scalar).}

\item{size}{Size of date samples to draw. 
Default: \code{size = 1}.}

\item{...}{Other arguments.
(Use for specifying \code{replace}, as passed to \code{sample()}.)}
}
\value{
A vector of class "Date".
}
\description{
\code{sample_date} draws a sample of  
\code{n} random dates from a given range.
}
\details{
By default, \code{sample_date} draws \code{n = 1} 
random date (as a "Date" object) in the range 
\code{from = "1970-01-01"} 
\code{to = Sys.Date()} (current date).

Both \code{from} and \code{to} currently 
need to be scalars (i.e., with a length of 1).
}
\examples{
sample_date()
sort(sample_date(size = 10))
sort(sample_date(from = "2020-02-28", to = "2020-03-01", 
     size = 10, replace = TRUE))  # 2020 is a leap year

# Note: Oddity with sample():
sort(sample_date(from = "2020-01-01", to = "2020-01-01", size = 10, replace = TRUE))  # range of 0!
# see sample(9:9, size = 10, replace = TRUE)

}
\seealso{
Other sampling functions: 
\code{\link{coin}()},
\code{\link{dice_2}()},
\code{\link{dice}()},
\code{\link{sample_char}()},
\code{\link{sample_time}()}
}
\concept{sampling functions}
