% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_charmap}
\alias{plot_charmap}
\title{Plot a character map as a tile plot with text labels.}
\usage{
plot_charmap(
  x = NA,
  file = "",
  lbl_tiles = TRUE,
  col_lbl = "black",
  angle = 0,
  cex = 3,
  fontface = 1,
  family = "sans",
  col_bg = "grey80",
  borders = FALSE,
  border_col = "white",
  border_size = 0.5
)
}
\arguments{
\item{x}{A character map, as generated by 
\code{\link{map_text_coord}} or 
\code{\link{map_text_regex}} (as df). 
Alternatively, some text to map or plot (as a character vector). 
Different elements denote different lines of text. 
If \code{x = NA} (as per default), 
the \code{file} argument is used to read 
a text file or user input from the Console.}

\item{file}{A text file to read (or its path). 
If \code{file = ""} (as per default), 
\code{scan} is used to read user input from the Console. 
If a text file is stored in a sub-directory, 
enter its path and name here (without any leading or 
trailing "." or "/").}

\item{lbl_tiles}{Add character labels to tiles? 
Default: \code{lbl_tiles = TRUE} (i.e., show labels).}

\item{col_lbl}{Default color of text labels 
(unless specified as a column \code{col_fg} of \code{x}).
Default: \code{col_lbl = "black"}.}

\item{angle}{Default angle of text labels 
(unless specified as a column of \code{x}).  
Default: \code{angle = 0}.}

\item{cex}{Character size (numeric). 
Default: \code{cex = 3}.}

\item{fontface}{Font face of text labels (numeric). 
Default: \code{fontface = 1}, (from 1 to 4).}

\item{family}{Font family of text labels (name).
Default: \code{family = "sans"}. 
Alternative options: "sans", "serif", or "mono".}

\item{col_bg}{Default color to fill background tiles 
(unless specified as a column \code{col_bg} of \code{x}).
Default: \code{col_bg = "grey80"}.}

\item{borders}{Boolean: Add borders to tiles? 
Default: \code{borders = FALSE} (i.e., no borders).}

\item{border_col}{Color of tile borders. 
Default: \code{border_col = "white"}.}

\item{border_size}{Size of tile borders. 
Default: \code{border_size = 0.5}.}
}
\value{
A plot generated by \strong{ggplot2}.
}
\description{
\code{plot_charmap} plots a character map and some aesthetics 
as a tile plot with text labels (using \strong{ggplot2}).
}
\details{
\code{plot_charmap} is based on \code{\link{plot_chars}}. 
As it only contains the plotting-related parts, 
it assumes a character map generated by 
\code{\link{map_text_regex}} as input. 

The plot generated by \code{plot_charmap} is character-based: 
Individual characters are plotted at equidistant x-y-positions 
and aesthetic variables are used for text labels and tile fill colors.
}
\examples{
# (0) Prepare: 
ts <- c("Hello world!", "This is a test to test this splendid function", 
        "Does this work?", "That's good.", "Please carry on.")
sum(nchar(ts))  

# (1) From character map:
# (a) simple: 
cm_1 <- map_text_coord(x = ts, flip_y = TRUE)
plot_charmap(cm_1)

# (b) pattern matching (regex): 
cm_2 <- map_text_regex(ts, lbl_hi = "\\\\b\\\\w{4}\\\\b", bg_hi = "[good|test]", 
                       lbl_rotate = "[^aeiou]", angle_fg = c(-45, +45))
plot_charmap(cm_2)                      

# (2) Alternative inputs:     
# (a) From text string(s):
plot_charmap(ts)

# (b) From user input:
# plot_charmap()  # (enter text in Console)
 
# (c) From text file:
# cat("Hello world!", "This is a test file.",
#      "Can you see this text?",
#      "Good! Please carry on...",
#      file = "test.txt", sep = "\n")

# plot_charmap(file = "test.txt")

# unlink("test.txt")  # clean up (by deleting file). 

}
\seealso{
\code{\link{plot_chars}} for creating and plotting character maps; 
\code{\link{plot_text}} for plotting characters and color tiles by frequency; 
\code{\link{map_text_regex}} for mapping text to a character table and matching patterns; 
\code{\link{map_text_coord}} for mapping text to a table of character coordinates; 
\code{\link{read_ascii}} for reading text inputs into a character string; 
\code{\link{pal_ds4psy}} for default color palette.

Other plot functions: 
\code{\link{plot_chars}()},
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
