% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_day}
\alias{what_day}
\title{What day (of the week) is it?}
\usage{
what_day(when = Sys.Date(), abbr = FALSE)
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = Sys.Date()}. 
Using \code{as.Date(when)} to convert strings into dates 
if a different \code{when} is provided.}

\item{abbr}{Boolean: Return abbreviated?
Default: \code{abbr = FALSE}.}
}
\description{
\code{what_day} provides a satisficing version of 
to determine the day of the week 
corresponding to a given date.
}
\details{
\code{what_day} returns the weekday  
of \code{when} or of \code{Sys.Date()} 
(as a character string).
}
\examples{
what_day()
what_day(abbr = TRUE)

what_day(when = Sys.time())  # with POSIXct time

# with date vector (as characters):
ds <- c("2020-01-01", "2020-02-29", "2020-12-24", "2020-12-31")
what_day(when = ds)
what_day(when = ds, abbr = TRUE)

# with time vector (strings of POSIXct times):
ts <- c("2020-12-25 10:11:12 CET", "2020-12-31 23:59:59")
what_day(ts)

}
\seealso{
\code{what_date()} function to obtain dates; 
\code{what_time()} function to obtain times; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
