% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_fun.R
\name{num_as_ordinal}
\alias{num_as_ordinal}
\title{Convert a number into an ordinal character sequence.}
\usage{
num_as_ordinal(x, sep = "")
}
\arguments{
\item{x}{Number(s) to convert (required, accepts numeric vectors).}

\item{sep}{Decimal separator to use.
Default: \code{sep = ""} (i.e., no separator).}
}
\description{
\code{num_as_ordinal} converts a given (cardinal) number 
into an ordinal character sequence.
}
\details{
The function currently only works for the English language and 
does not accepts inputs that are characters, dates, or times.  

Note that the \code{toOrdinal()} function of the \strong{toOrdinal} package works 
for multiple languages and provides a \code{toOrdinalDate()} function. 

\strong{Caveat:} Note that this function illustrates how numbers, 
characters, \code{for} loops, and \code{paste()} can be combined 
when writing functions. It is not written efficiently or well.
}
\examples{
num_as_ordinal(1:4)
num_as_ordinal(10:14)    # all with "th"
num_as_ordinal(110:114)  # all with "th"
num_as_ordinal(120:124)  # 4 different suffixes
num_as_ordinal(1:15, sep = "-")  # using sep

# Note special cases:
num_as_ordinal(NA)
num_as_ordinal("1")
num_as_ordinal(Sys.Date())
num_as_ordinal(Sys.time())
num_as_ordinal(seq(1.99, 2.14, by = .01))


}
\seealso{
\code{toOrdinal()} function of the \strong{toOrdinal} package.

Other utility functions: 
\code{\link{is.wholenumber}()},
\code{\link{num_as_char}()}
}
\concept{utility functions}
