% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhat_estimation_functions.R
\name{qhat_sl}
\alias{qhat_sl}
\title{Estimate marginal and joint distribution of lists j and k using super learner.}
\usage{
qhat_sl(
  List.train,
  List.test,
  K = 2,
  j = 1,
  k = 2,
  margin = 0.005,
  sl.lib = c("SL.glm", "SL.gam", "SL.glm.interaction", "SL.ranger", "SL.glmnet"),
  num_cores = NA,
  ...
)
}
\arguments{
\item{List.train}{The training data matrix used to estimate the distibution functions.}

\item{List.test}{The data matrix on which the estimator function is applied.}

\item{K}{The number of lists in the data.}

\item{j}{The first list that is conditionally independent.}

\item{k}{The second list that is conditionally independent.}

\item{margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{sl.lib}{The functions from the SuperLearner library to be used for model fitting.}

\item{num_cores}{The number of cores to be used for paralellization in Super Learner.}

\item{...}{Any extra arguments passed into the function.}
}
\value{
A list of the marginal and joint distribution probabilities q_1, q_2 and q_12.
}
\description{
Estimate marginal and joint distribution of lists j and k using super learner.
}
\examples{
\dontrun{
qhat = qhat_sl(List.train = List.train, List.test = List.test, margin = 0.005, num_cores = 1)
q1 = qhat$q1
q2 = qhat$q2
q12 = qhat$q12
}
}
\references{
Eric Polley, Erin LeDell, Chris Kennedy and Mark van der Laan (2021). SuperLearner: Super Learner Prediction. \emph{R package version 2.0-28}. https://CRAN.R-project.org/package=SuperLearner

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2008) Super Learner, \emph{Statistical Applications of Genetics and Molecular Biology}, 6, article 25.
}
