% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic4.R
\name{logistic4_fn}
\alias{logistic4_fn}
\title{4-parameter logistic function}
\usage{
logistic4_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the logistic function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, beta, eta, phi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 4-parameter logistic function.
}
\details{
The 4-parameter logistic function \verb{f(x; theta)} is defined here as

\code{alpha + (beta - alpha) / (1 + exp(-eta * (x - phi)))}

where \code{theta = c(alpha, beta, eta, phi)}, \code{alpha} is the lower horizontal
asymptote, \code{beta > alpha} is the upper horizontal asymptote, \code{eta} is the
steepness of the curve or growth rate (also known as the Hill coefficient),
and \code{phi} is the value of \code{x} at which the curve is equal to its mid-point.
}
