% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DErand.R
\name{DErand}
\alias{DErand}
\title{Discriminative parameter learning of BN by DE variant rand/k/.}
\usage{
DErand(
  NP = 40,
  G = 100,
  data,
  class.name,
  F = 0.5,
  CR = 0.7,
  mutation.pairs = c(1, 2),
  crossover = c("bin", "exp"),
  structure = c("nb", "tancl", "hc"),
  edgelist = NULL,
  verbose = 25,
  ...
)
}
\arguments{
\item{NP}{positive integer giving the number of candidate solutions in the initial population.}

\item{G}{positive integer specifying the maximum number of generations that may be performed before the algorithm is halted.}

\item{data}{The data frame from which to learn the classifier.}

\item{class.name}{A character. Name of the class variable.}

\item{F}{A numeric. Mutation factor. Default is 0.5.}

\item{CR}{A numeric. Cross over factor. Default is 0.7.}

\item{mutation.pairs}{A positive integer giving the number of pairs (1 or 2) used in the mutation step.}

\item{crossover}{A character. Crossover type among binomial (bin) or exponential (exp).}

\item{structure}{A character. Name of the structure learning function. "tan" uses Tree Augmented Network.
"nb" uses Naive Bayes. "hc" uses Hill Climbing.}

\item{edgelist}{A matrix. An optional edge list to use a custom BN structure.
that will replace de learned structure.}

\item{verbose}{positive integer indicating the number of generations until the iteration progress should be printed.}

\item{...}{other structure learning options from \link[bnclassify]{tan_cl} or \link[bnclassify]{tan_hc}.}
}
\value{
An object of class \code{DE}, which is a list with the following components:
\item{Best}{A \code{bnc_bn} object with the best individual in the final population, i.e., the bayesian network with the best fitness at the end of evolution.}
\item{BestCLL}{A numeric specifying the Conditional Log-Likelihood of the best individual.}
\item{pobFinal}{A list of \code{bnc_bn} objects with the final population, i.e., a set of bayesian networks with optimized parameters at the end of evolution.}
\item{CLLPobFinal}{A numeric vector specifying the Conditional Log-Likelihood of the final population.}
\item{N.evals}{An integer giving the total number of evaluations.}
\item{convergence}{A numeric vector giving the maximum Conditional Log-Likelihood at each generation.}
\item{evaluations}{An integer vector giving the total number of evaluations at each generation.}
}
\description{
Learn parameters of a Bayesian Network in a discriminative way
by Differential Evolution with variant rand/k
}
\examples{
# Load data
data(car)
# Parameter learning with "rand/2/bin" variant
dpl.rand2bin <- DErand(NP = 25, G = 40, data = car, class.name = names(car)[7], F = 0.5,
CR = 0.5, mutation.pairs = 2, crossover = "bin", structure = "tan", edgelist = NULL,
verbose = 10)
# Print results
print(dpl.rand2bin)
\dontrun{plot(dpl.rand2bin)}
}
