% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clones.R
\name{formatClones}
\alias{formatClones}
\title{Generate an ordered list of airrClone objects for lineage construction}
\usage{
formatClones(
  data,
  seq = "sequence_alignment",
  clone = "clone_id",
  subclone = "subclone_id",
  nproc = 1,
  chain = "H",
  heavy = "IGH",
  cell = "cell_id",
  locus = "locus",
  minseq = 2,
  split_light = FALSE,
  majoronly = FALSE,
  columns = NULL,
  ...
)
}
\arguments{
\item{data}{data.frame containing the AIRR or Change-O data for a clone.
See \link{makeAirrClone} for required columns and their defaults}

\item{seq}{sequence alignment column name.}

\item{clone}{name of the column containing the identifier for the clone. All 
entries in this column should be identical.}

\item{subclone}{name of the column containing the identifier for the subclone.}

\item{nproc}{number of cores to parallelize formating over.}

\item{chain}{if HL, include light chain information if available.}

\item{heavy}{name of heavy chain locus (default = "IGH")}

\item{cell}{name of the column containing cell assignment information}

\item{locus}{name of the column containing locus information}

\item{minseq}{minimum numbner of sequences per clone}

\item{split_light}{split or lump subclones? See \code{getSubclones}.}

\item{majoronly}{only return largest subclone and sequences without light chains}

\item{columns}{additional data columns to include in output}

\item{...}{additional arguments to pass to makeAirrClone}
}
\value{
A tibble of \link{airrClone} objects containing modified clones.
}
\description{
\code{formatClones} takes a \code{data.frame} or \code{tibble} with AIRR or 
Change-O style columns as input and masks gap positions, masks ragged ends, 
removes duplicates sequences, and merges annotations associated with duplicate
sequences. If specified, it will un-merge duplicate sequences with different 
values specified in the \code{trait} option. It returns a list of \code{airrClone}
objects ordered by number of sequences which serve as input for lineage reconstruction.
}
\details{
This function is a wrapper for \link{makeAirrClone}. Also removes whitespace,
;, :, and = from ids
}
\examples{
data(ExampleAirr)
# Select two clones, for demonstration purpose
sel <- c("3170", "3184")
clones <- formatClones(ExampleAirr[ExampleAirr$clone_id \%in\% sel,],trait="sample_id")
}
\seealso{
Executes in order \link{makeAirrClone}. Returns a tibble of 
\link{airrClone} objects 
     which serve as input to \link{getTrees} and \link{findSwitches}.
}
